/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.context;

import com.chutneytesting.action.spi.Action;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Logger;
import com.chutneytesting.action.spi.time.Duration;
import com.chutneytesting.action.spi.validation.ActionValidatorsUtils;
import com.chutneytesting.action.spi.validation.Validator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SleepAction
implements Action {
    private final Logger logger;
    private final String duration;

    public SleepAction(Logger logger, @Input(value="duration") String duration) {
        this.logger = logger;
        this.duration = duration;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{ActionValidatorsUtils.durationValidation((String)this.duration, (String)"duration")});
    }

    public ActionExecutionResult execute() {
        this.logger.info("Start sleeping for " + this.duration);
        try {
            TimeUnit.MILLISECONDS.sleep(Duration.parse((String)this.duration).toMilliseconds());
        }
        catch (InterruptedException e) {
            this.logger.error("Stop sleeping due to Interruption signal");
            return ActionExecutionResult.ko();
        }
        this.logger.info("Stop sleeping for " + this.duration);
        return ActionExecutionResult.ok();
    }
}

