/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.assertion.compare;

import com.chutneytesting.action.assertion.compare.CompareExecutor;
import com.chutneytesting.action.spi.ActionExecutionResult;
import com.chutneytesting.action.spi.injectable.Logger;
import java.util.function.BiFunction;

public abstract class AbstractCompareNumberAction
implements CompareExecutor {
    protected abstract BiFunction<Double, Double, Boolean> compareFunction();

    protected abstract String getFunctionName();

    protected abstract String getOppositeFunctionName();

    @Override
    public ActionExecutionResult compare(Logger logger, String actual, String expected) {
        Double actualD = this.parse(logger, actual);
        Double expectedD = this.parse(logger, expected);
        Boolean apply = this.compareFunction().apply(actualD, expectedD);
        if (apply.booleanValue()) {
            logger.info("[" + actual + "] " + this.getFunctionName() + " [" + expected + "]");
            return ActionExecutionResult.ok();
        }
        logger.error("[" + actual + "] " + this.getOppositeFunctionName() + " [" + expected + "]");
        return ActionExecutionResult.ko();
    }

    private Double parse(Logger logger, String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            logger.error("[" + value + "] is Not Numeric");
            return Double.NaN;
        }
    }
}

