/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm;

public class Type {
    private static final char[] PRIMITIVE_DESCRIPTORS = new char[]{'V', 'Z', 'C', 'B', 'S', 'I', 'F', 'J', 'D'};
    public static final Type VOID_TYPE = new Type(0, PRIMITIVE_DESCRIPTORS, 0, 1);
    public static final Type BOOLEAN_TYPE = new Type(1, PRIMITIVE_DESCRIPTORS, 1, 1);
    public static final Type CHAR_TYPE = new Type(2, PRIMITIVE_DESCRIPTORS, 2, 1);
    public static final Type BYTE_TYPE = new Type(3, PRIMITIVE_DESCRIPTORS, 3, 1);
    public static final Type SHORT_TYPE = new Type(4, PRIMITIVE_DESCRIPTORS, 4, 1);
    public static final Type INT_TYPE = new Type(5, PRIMITIVE_DESCRIPTORS, 5, 1);
    public static final Type FLOAT_TYPE = new Type(6, PRIMITIVE_DESCRIPTORS, 6, 1);
    public static final Type LONG_TYPE = new Type(7, PRIMITIVE_DESCRIPTORS, 7, 1);
    public static final Type DOUBLE_TYPE = new Type(8, PRIMITIVE_DESCRIPTORS, 8, 1);
    private final int sort;
    private final char[] valueBuffer;
    private final int valueOffset;
    private final int valueLength;

    private Type(int n, char[] cArray, int n2, int n3) {
        this.sort = n;
        this.valueBuffer = cArray;
        this.valueOffset = n2;
        this.valueLength = n3;
    }

    public static Type getType(String string) {
        char[] cArray = string.toCharArray();
        return Type.getType(cArray, 0, cArray.length);
    }

    public static Type getObjectType(String string) {
        char[] cArray = string.toCharArray();
        return new Type(cArray[0] == '[' ? 9 : 12, cArray, 0, cArray.length);
    }

    public static Type getMethodType(String string) {
        char[] cArray = string.toCharArray();
        return new Type(11, cArray, 0, cArray.length);
    }

    public static Type[] getArgumentTypes(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 1;
        while (cArray[n2] != ')') {
            while (cArray[n2] == '[') {
                ++n2;
            }
            if (cArray[n2++] == 'L') {
                while (cArray[n2++] != ';') {
                }
            }
            ++n;
        }
        Type[] typeArray = new Type[n];
        n2 = 1;
        int n3 = 0;
        while (cArray[n2] != ')') {
            int n4 = n2;
            while (cArray[n2] == '[') {
                ++n2;
            }
            if (cArray[n2++] == 'L') {
                while (cArray[n2++] != ';') {
                }
            }
            typeArray[n3++] = Type.getType(cArray, n4, n2 - n4);
        }
        return typeArray;
    }

    public static int getArgumentsAndReturnSizes(String string) {
        int n = 1;
        int n2 = 1;
        char c = string.charAt(n2);
        while (c != ')') {
            if (c == 'J' || c == 'D') {
                ++n2;
                n += 2;
            } else {
                while (string.charAt(n2) == '[') {
                    ++n2;
                }
                if (string.charAt(n2++) == 'L') {
                    while (string.charAt(n2++) != ';') {
                    }
                }
                ++n;
            }
            c = string.charAt(n2);
        }
        c = string.charAt(n2 + 1);
        if (c == 'V') {
            return n << 2;
        }
        int n3 = c == 'J' || c == 'D' ? 2 : 1;
        return n << 2 | n3;
    }

    private static Type getType(char[] cArray, int n, int n2) {
        switch (cArray[n]) {
            case 'V': {
                return VOID_TYPE;
            }
            case 'Z': {
                return BOOLEAN_TYPE;
            }
            case 'C': {
                return CHAR_TYPE;
            }
            case 'B': {
                return BYTE_TYPE;
            }
            case 'S': {
                return SHORT_TYPE;
            }
            case 'I': {
                return INT_TYPE;
            }
            case 'F': {
                return FLOAT_TYPE;
            }
            case 'J': {
                return LONG_TYPE;
            }
            case 'D': {
                return DOUBLE_TYPE;
            }
            case '[': {
                return new Type(9, cArray, n, n2);
            }
            case 'L': {
                return new Type(10, cArray, n + 1, n2 - 2);
            }
            case '(': {
                return new Type(11, cArray, n, n2);
            }
        }
        throw new IllegalArgumentException();
    }

    public int getSort() {
        return this.sort == 12 ? 10 : this.sort;
    }

    public int getDimensions() {
        int n = 1;
        while (this.valueBuffer[this.valueOffset + n] == '[') {
            ++n;
        }
        return n;
    }

    public Type getElementType() {
        int n = this.getDimensions();
        return Type.getType(this.valueBuffer, this.valueOffset + n, this.valueLength - n);
    }

    public String getClassName() {
        switch (this.sort) {
            case 0: {
                return "void";
            }
            case 1: {
                return "boolean";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "long";
            }
            case 8: {
                return "double";
            }
            case 9: {
                StringBuilder stringBuilder = new StringBuilder(this.getElementType().getClassName());
                for (int i = this.getDimensions(); i > 0; --i) {
                    stringBuilder.append("[]");
                }
                return stringBuilder.toString();
            }
            case 10: 
            case 12: {
                return new String(this.valueBuffer, this.valueOffset, this.valueLength).replace('/', '.');
            }
        }
        throw new AssertionError();
    }

    public String getInternalName() {
        return new String(this.valueBuffer, this.valueOffset, this.valueLength);
    }

    public String getDescriptor() {
        if (this.sort == 10) {
            return new String(this.valueBuffer, this.valueOffset - 1, this.valueLength + 2);
        }
        if (this.sort == 12) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('L');
            stringBuilder.append(this.valueBuffer, this.valueOffset, this.valueLength);
            stringBuilder.append(';');
            return stringBuilder.toString();
        }
        return new String(this.valueBuffer, this.valueOffset, this.valueLength);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Type)) {
            return false;
        }
        Type type = (Type)object;
        if ((this.sort == 12 ? 10 : this.sort) != (type.sort == 12 ? 10 : type.sort)) {
            return false;
        }
        int n = this.valueOffset;
        int n2 = n + this.valueLength;
        int n3 = type.valueOffset;
        int n4 = n3 + type.valueLength;
        if (n2 - n != n4 - n3) {
            return false;
        }
        int n5 = n;
        int n6 = n3;
        while (n5 < n2) {
            if (this.valueBuffer[n5] != type.valueBuffer[n6]) {
                return false;
            }
            ++n5;
            ++n6;
        }
        return true;
    }

    public int hashCode() {
        int n = 13 * (this.sort == 12 ? 10 : this.sort);
        if (this.sort >= 9) {
            int n2 = this.valueOffset + this.valueLength;
            for (int i = this.valueOffset; i < n2; ++i) {
                n = 17 * (n + this.valueBuffer[i]);
            }
        }
        return n;
    }

    public String toString() {
        return this.getDescriptor();
    }
}

