/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Function;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Predicate;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Cut;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Ordering;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Range$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Range$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Range$RangeLexOrdering;
import java.io.Serializable;
import javax.annotation.Nullable;

public final class Range
implements Predicate,
Serializable {
    private static final Function LOWER_BOUND_FN = new Range$1();
    private static final Function UPPER_BOUND_FN = new Range$2();
    static final Ordering RANGE_LEX_ORDERING = new Range$RangeLexOrdering(null);
    private static final Range ALL = new Range(Cut.belowAll(), Cut.aboveAll());
    final Cut lowerBound;
    final Cut upperBound;

    private Range(Cut cut, Cut cut2) {
        this.lowerBound = (Cut)Preconditions.checkNotNull(cut);
        this.upperBound = (Cut)Preconditions.checkNotNull(cut2);
        if (cut.compareTo(cut2) > 0 || cut == Cut.aboveAll() || cut2 == Cut.belowAll()) {
            throw new IllegalArgumentException("Invalid range: " + Range.toString(cut, cut2));
        }
    }

    public boolean contains(Comparable comparable) {
        Preconditions.checkNotNull(comparable);
        return this.lowerBound.isLessThan(comparable) && !this.upperBound.isLessThan(comparable);
    }

    @Deprecated
    public boolean apply(Comparable comparable) {
        return this.contains(comparable);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof Range) {
            Range range = (Range)object;
            return this.lowerBound.equals(range.lowerBound) && this.upperBound.equals(range.upperBound);
        }
        return false;
    }

    public int hashCode() {
        return this.lowerBound.hashCode() * 31 + this.upperBound.hashCode();
    }

    public String toString() {
        return Range.toString(this.lowerBound, this.upperBound);
    }

    private static String toString(Cut cut, Cut cut2) {
        StringBuilder stringBuilder = new StringBuilder(16);
        cut.describeAsLowerBound(stringBuilder);
        stringBuilder.append('\u2025');
        cut2.describeAsUpperBound(stringBuilder);
        return stringBuilder.toString();
    }

    static int compareOrThrow(Comparable comparable, Comparable comparable2) {
        return comparable.compareTo(comparable2);
    }
}

