/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Function;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Joiner$MapJoiner;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Predicate;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Predicates;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CollectPreconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Collections2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMap$Builder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.MapMaker;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps$5;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps$6;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps$EntryFunction;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public final class Maps {
    static final Joiner$MapJoiner STANDARD_JOINER = Collections2.STANDARD_JOINER.withKeyValueSeparator("=");

    static Function keyFunction() {
        return Maps$EntryFunction.KEY;
    }

    static Function valueFunction() {
        return Maps$EntryFunction.VALUE;
    }

    static Iterator keyIterator(Iterator iterator) {
        return Iterators.transform(iterator, Maps.keyFunction());
    }

    static Iterator valueIterator(Iterator iterator) {
        return Iterators.transform(iterator, Maps.valueFunction());
    }

    public static HashMap newHashMap() {
        return new HashMap();
    }

    static int capacity(int n) {
        if (n < 3) {
            CollectPreconditions.checkNonnegative(n, "expectedSize");
            return n + 1;
        }
        if (n < 0x40000000) {
            return (int)((float)n / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }

    public static LinkedHashMap newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static ConcurrentMap newConcurrentMap() {
        return new MapMaker().makeMap();
    }

    static Iterator asMapEntryIterator(Set set, Function function) {
        return new Maps$1(set.iterator(), function);
    }

    public static Map.Entry immutableEntry(@Nullable Object object, @Nullable Object object2) {
        return new ImmutableEntry(object, object2);
    }

    static Map.Entry unmodifiableEntry(Map.Entry entry) {
        Preconditions.checkNotNull(entry);
        return new Maps$5(entry);
    }

    static UnmodifiableIterator unmodifiableEntryIterator(Iterator iterator) {
        return new Maps$6(iterator);
    }

    static Predicate valuePredicateOnEntries(Predicate predicate) {
        return Predicates.compose(predicate, Maps.valueFunction());
    }

    static Object safeGet(Map map, @Nullable Object object) {
        Preconditions.checkNotNull(map);
        try {
            return map.get(object);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    static boolean safeContainsKey(Map map, Object object) {
        Preconditions.checkNotNull(map);
        try {
            return map.containsKey(object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    static Object safeRemove(Map map, Object object) {
        Preconditions.checkNotNull(map);
        try {
            return map.remove(object);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    static boolean containsEntryImpl(Collection collection, Object object) {
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        return collection.contains(Maps.unmodifiableEntry((Map.Entry)object));
    }

    static boolean equalsImpl(Map map, Object object) {
        if (map == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map2 = (Map)object;
            return map.entrySet().equals(map2.entrySet());
        }
        return false;
    }

    static String toStringImpl(Map map) {
        StringBuilder stringBuilder = Collections2.newStringBuilderForCollection(map.size()).append('{');
        STANDARD_JOINER.appendTo(stringBuilder, map);
        return stringBuilder.append('}').toString();
    }

    @Nullable
    static Object keyOrNull(@Nullable Map.Entry entry) {
        return entry == null ? null : entry.getKey();
    }

    @Nullable
    static Object valueOrNull(@Nullable Map.Entry entry) {
        return entry == null ? null : entry.getValue();
    }

    static ImmutableMap indexMap(Collection collection) {
        ImmutableMap$Builder immutableMap$Builder = new ImmutableMap$Builder(collection.size());
        int n = 0;
        for (Object e : collection) {
            immutableMap$Builder.put(e, n++);
        }
        return immutableMap$Builder.build();
    }
}

