/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.sizeof;

import com.carrotsearch.sizeof.MurmurHash3;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class IdentityHashSet<KType>
implements Iterable<KType> {
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int MIN_CAPACITY = 4;
    public Object[] keys;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;

    public IdentityHashSet() {
        this(16, 0.75f);
    }

    public IdentityHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IdentityHashSet(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(4, initialCapacity);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor < 1.0f) : "Load factor must be between (0, 1).";
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public boolean add(KType e) {
        Object existing;
        assert (e != null) : "Null keys not allowed.";
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.keys.length - 1;
        int slot = IdentityHashSet.rehash(e) & mask;
        while ((existing = this.keys[slot]) != null) {
            if (e == existing) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.keys[slot] = e;
        return true;
    }

    public boolean contains(KType e) {
        Object existing;
        int mask = this.keys.length - 1;
        int slot = IdentityHashSet.rehash(e) & mask;
        while ((existing = this.keys[slot]) != null) {
            if (e == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    private static int rehash(Object o) {
        return MurmurHash3.hash(System.identityHashCode(o));
    }

    private void expandAndRehash() {
        Object[] oldKeys = this.keys;
        assert (this.assigned >= this.resizeThreshold);
        this.allocateBuffers(this.nextCapacity(this.keys.length));
        int mask = this.keys.length - 1;
        int i = 0;
        while (i < oldKeys.length) {
            Object key = oldKeys[i];
            if (key != null) {
                int slot = IdentityHashSet.rehash(key) & mask;
                while (this.keys[slot] != null) {
                    slot = slot + 1 & mask;
                }
                this.keys[slot] = key;
            }
            ++i;
        }
        Arrays.fill(oldKeys, null);
    }

    private void allocateBuffers(int capacity) {
        this.keys = new Object[capacity];
        this.resizeThreshold = (int)((float)capacity * 0.75f);
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        int capacity = 4;
        while (capacity < requestedCapacity) {
            capacity <<= 1;
        }
        return capacity;
    }

    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.keys, null);
    }

    public int size() {
        return this.assigned;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<KType> iterator() {
        return new Iterator<KType>(){
            int pos = -1;
            Object nextElement = this.fetchNext();

            @Override
            public boolean hasNext() {
                return this.nextElement != null;
            }

            @Override
            public KType next() {
                Object r = this.nextElement;
                if (r == null) {
                    throw new NoSuchElementException();
                }
                this.nextElement = this.fetchNext();
                return r;
            }

            private Object fetchNext() {
                ++this.pos;
                while (this.pos < IdentityHashSet.this.keys.length && IdentityHashSet.this.keys[this.pos] == null) {
                    ++this.pos;
                }
                return this.pos >= IdentityHashSet.this.keys.length ? null : IdentityHashSet.this.keys[this.pos];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

