/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.migration;

import com.carbonfive.db.jdbc.DatabaseType;
import com.carbonfive.db.jdbc.ScriptRunner;
import com.carbonfive.db.migration.AbstractMigration;
import com.carbonfive.db.migration.MigrationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.springframework.core.io.Resource;

public class SQLScriptMigration
extends AbstractMigration {
    private Resource resource;

    public SQLScriptMigration(String version, Resource resource) {
        super(version);
        Validate.isTrue((resource != null ? 1 : 0) != 0);
        this.resource = resource;
    }

    public void migrate(DatabaseType dbType, Connection connection) {
        InputStream inputStream = null;
        try {
            inputStream = this.resource.getInputStream();
            ScriptRunner scriptRunner = new ScriptRunner(dbType);
            scriptRunner.execute(connection, (Reader)new InputStreamReader(inputStream, "UTF-8"));
            Validate.isTrue((!connection.isClosed() ? 1 : 0) != 0, (String)"JDBC Connection should not be closed.");
        }
        catch (IOException e) {
            throw new MigrationException("Error while reading script input stream.", e);
        }
        catch (SQLException e) {
            throw new MigrationException("Error while executing migration script.", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

