/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.migration;

import com.carbonfive.db.migration.Migration;
import com.carbonfive.db.migration.MigrationException;
import com.carbonfive.db.migration.MigrationFactory;
import com.carbonfive.db.migration.MigrationResolver;
import com.carbonfive.db.migration.SimpleVersionExtractor;
import com.carbonfive.db.migration.VersionExtractor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMigrationResolver
implements MigrationResolver {
    private static final String CLASSPATH_MIGRATIONS_SQL = "classpath:/db/migrations/";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private String migrationsLocation;
    private VersionExtractor versionExtractor;
    private MigrationFactory migrationFactory = new MigrationFactory();

    public ResourceMigrationResolver() {
        this(CLASSPATH_MIGRATIONS_SQL);
    }

    public ResourceMigrationResolver(String migrationsLocation) {
        this(migrationsLocation, new SimpleVersionExtractor());
    }

    public ResourceMigrationResolver(String migrationsLocation, VersionExtractor versionExtractor) {
        this.setMigrationsLocation(migrationsLocation);
        this.versionExtractor = versionExtractor;
        this.setVersionExtractor(this.versionExtractor);
    }

    @Override
    public Set<Migration> resolve() {
        ArrayList<Resource> resources;
        HashSet<Migration> migrations = new HashSet<Migration>();
        PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
        try {
            resources = new ArrayList<Resource>(Arrays.asList(patternResolver.getResources(this.migrationsLocation)));
        }
        catch (IOException e) {
            throw new MigrationException(e);
        }
        CollectionUtils.filter(resources, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return !((Resource)object).getFilename().startsWith(".");
            }
        });
        if (resources.isEmpty()) {
            String message = "No migrations were found using resource pattern '" + this.migrationsLocation + "'. Terminating migration.";
            this.log.error(message);
            throw new MigrationException(message);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Found " + resources.size() + " resources: " + StringUtils.collectionToCommaDelimitedString(resources));
        }
        for (Resource resource : resources) {
            String version = this.versionExtractor.extractVersion(resource.getFilename());
            migrations.add(this.migrationFactory.create(version, resource));
        }
        return migrations;
    }

    public void setMigrationsLocation(String migrationsLocation) {
        if (!migrationsLocation.endsWith("*")) {
            migrationsLocation = migrationsLocation + "*";
        }
        this.migrationsLocation = migrationsLocation;
    }

    public void setVersionExtractor(VersionExtractor versionExtractor) {
        this.versionExtractor = versionExtractor;
    }

    public void setMigrationFactory(MigrationFactory migrationFactory) {
        this.migrationFactory = migrationFactory;
    }
}

