/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.webdriver;

import com.capgemini.mrchecker.selenium.core.BasePage;
import com.capgemini.mrchecker.selenium.core.newDrivers.INewWebDriver;
import com.capgemini.mrchecker.selenium.core.utils.WebElementUtils;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;

public class WdUtility {
    private WdUtility() {
    }

    public static String getStylePropertyByJS(INewWebDriver driver, String querySelector, String pseudoElement, String cssProperty) {
        String script = "return window.getComputedStyle(document.querySelector('" + querySelector + "'),'" + pseudoElement + "').getPropertyValue('" + cssProperty + "')";
        JavascriptExecutor js = (JavascriptExecutor)driver;
        return (String)js.executeScript(script, new Object[0]);
    }

    public static List<Date> createDateList(List<WebElement> dateElements, String pattern) throws ParseException {
        ArrayList<Date> datesList = new ArrayList<Date>();
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        for (WebElement dateElement : dateElements) {
            Date date = dateFormat.parse(dateElement.getText());
            datesList.add(date);
        }
        return datesList;
    }

    public static List<String> createStringList(List<WebElement> elements) {
        ArrayList<String> stringsList = new ArrayList<String>();
        for (WebElement el : elements) {
            stringsList.add(el.getText());
        }
        return stringsList;
    }

    public static int compareElementsInZAxis(WebElement firstElement, WebElement secondElement) {
        String firstElementCssZindex = firstElement.getCssValue("z-index");
        int firstElementValle = 0;
        if (!firstElementCssZindex.isEmpty()) {
            firstElementValle = Integer.parseInt(firstElementCssZindex);
        }
        String secondElementCssZindex = secondElement.getCssValue("z-index");
        int secondElementValle = 0;
        if (!secondElementCssZindex.isEmpty()) {
            secondElementValle = Integer.parseInt(secondElementCssZindex);
        }
        if (firstElementValle == secondElementValle) {
            return 0;
        }
        if (firstElementValle > secondElementValle) {
            return 1;
        }
        return -1;
    }

    public static boolean isOverElement(WebElement firstElement, WebElement secondElement) {
        return WdUtility.compareElementsInZAxis(firstElement, secondElement) > 0;
    }

    public static boolean isTextDisplayedInsideElement(By selector, String text) {
        WebElement element = BasePage.getDriver().findElement(selector);
        return element.getText().contains(text);
    }

    public static boolean isTooltipDisplayed(WebElement element, WebElement tooltip) {
        BasePage.getAction().moveToElement(element).perform();
        return !tooltip.getCssValue("display").equals("none");
    }

    public static boolean isTooltipDisplayed(WebElement element, By waitForSelector) {
        WebElement tooltip = WebElementUtils.hoverOnElement(element, waitForSelector);
        return !tooltip.isDisplayed();
    }

    public static boolean isTextInCorrectFormat(By selector, String format) {
        WebElement element = BasePage.getDriver().findElement(selector);
        String elementText = element.getText();
        Pattern pattern = Pattern.compile(format);
        Matcher patternMatcher = pattern.matcher(elementText);
        return patternMatcher.find();
    }

    public static Map<String, String> getMapFromLists(By selectorKey, By selectorValue) {
        List<WebElement> keys = BasePage.getDriver().findElements(selectorKey);
        List<WebElement> values = BasePage.getDriver().findElements(selectorValue);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (keys.size() != values.size() || keys.size() == 0) {
            BFLogger.logError((String)"Incorrect lists - an empty map will be created");
            return map;
        }
        Iterator<WebElement> keyIterator = keys.iterator();
        Iterator<WebElement> valueIterator = values.iterator();
        while (keyIterator.hasNext() && valueIterator.hasNext()) {
            map.put(keyIterator.next().getText(), valueIterator.next().getText());
        }
        return map;
    }

    public static boolean isElementTextCropped(String selectorForElement) {
        JavascriptExecutor executor = (JavascriptExecutor)BasePage.getDriver();
        return (Boolean)executor.executeScript("var element = document.querySelector(arguments[0]); return (element.offsetWidth < element.scrollWidth);", new Object[]{selectorForElement});
    }

    public static boolean isElementContainsText(By selectorElement, String expectedText) {
        WebElement element = BasePage.getDriver().findElement(selectorElement);
        String elementText = element.getText();
        return elementText.contains(expectedText);
    }
}

