/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.utils;

import com.capgemini.mrchecker.selenium.core.BasePage;
import com.capgemini.mrchecker.selenium.core.exceptions.BFComponentStateException;
import com.capgemini.mrchecker.selenium.core.exceptions.BFRobotInitilizationException;
import com.capgemini.mrchecker.selenium.core.newDrivers.DriverManager;
import com.capgemini.mrchecker.selenium.core.utils.ScrollUtils;
import com.capgemini.mrchecker.selenium.core.utils.StringUtils;
import com.capgemini.mrchecker.selenium.core.utils.TimeUtills;
import com.capgemini.mrchecker.test.core.exceptions.BFWaitingTimeoutException;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import java.awt.AWTException;
import java.awt.Robot;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebElementUtils {
    private WebElementUtils() {
    }

    public static void nonBlockingClickOnWebElement(WebElement element) {
        ScrollUtils.scrollElementIntoView(element);
        element.sendKeys(new CharSequence[0]);
        try {
            Robot robot = new Robot();
            robot.keyPress(10);
            robot.keyRelease(10);
            BFLogger.logDebug((String)"Press mouse on element");
        }
        catch (AWTException e) {
            throw new BFRobotInitilizationException(e);
        }
    }

    public static boolean isWebElementHighlightedInColor(WebElement webElement, String color) {
        String colorAsString = webElement.getCssValue("background-color");
        return color.equalsIgnoreCase(colorAsString);
    }

    public static WebElement hoverOnElement(By elementSelector, By waitForSelector) {
        WebElement element = BasePage.getDriver().findElement(elementSelector);
        return WebElementUtils.hoverOnElement(element, waitForSelector);
    }

    public static WebElement hoverOnElement(WebElement elementToHoverOn, By waitForSelector) {
        long startTime = System.currentTimeMillis();
        BasePage.getAction().moveToElement(elementToHoverOn).build().perform();
        WebDriverWait wait = BasePage.getWebDriverWait();
        WebElement element = (WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)waitForSelector));
        BFLogger.logTime((long)startTime, (String)"hoverOnElement", (String)waitForSelector.toString());
        return element;
    }

    public static WebElement hoverOnElement(WebElement elementToHoverOn, WebElement waitForElement) {
        long startTime = System.currentTimeMillis();
        BasePage.getAction().moveToElement(elementToHoverOn).build().perform();
        WebDriverWait wait = BasePage.getWebDriverWait();
        WebElement element = (WebElement)wait.until((Function)ExpectedConditions.visibilityOf((WebElement)waitForElement));
        BFLogger.logTime((long)startTime, (String)"hoverOnElement", (String)waitForElement.toString());
        return element;
    }

    public static void waitForElementVisible(By elementToWaitFor) {
        WebElementUtils.waitForElementVisible(elementToWaitFor, DriverManager.EXPLICIT_WAIT);
    }

    public static void waitForElementVisible(By elementToWaitFor, Duration tiemout) {
        long startTime = System.currentTimeMillis();
        WebDriverWait wait = new WebDriverWait((WebDriver)BasePage.getDriver(), tiemout);
        wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)elementToWaitFor));
        BFLogger.logTime((long)startTime, (String)"waitForElementVisible", (String)elementToWaitFor.toString());
    }

    public static WebElement waitForElementVisible(WebElement elementToWaitFor) {
        long startTime = System.currentTimeMillis();
        WebDriverWait wait = BasePage.getWebDriverWait();
        WebElement element = (WebElement)wait.until((Function)ExpectedConditions.visibilityOf((WebElement)elementToWaitFor));
        BFLogger.logTime((long)startTime, (String)"waitForElementVisible", (String)elementToWaitFor.toString());
        return element;
    }

    public static boolean waitForElementNotVisible(By elementToWaitFor) {
        long startTime = System.currentTimeMillis();
        WebDriverWait wait = BasePage.getWebDriverWait();
        Boolean elementInvisibility = (Boolean)wait.until((Function)ExpectedConditions.invisibilityOfElementLocated((By)elementToWaitFor));
        BFLogger.logTime((long)startTime, (String)"waitForElementNotVisible", (String)elementToWaitFor.toString());
        return elementInvisibility;
    }

    public static boolean waitForElementNotVisible(WebElement elementToWaitFor) {
        long startTime = System.currentTimeMillis();
        WebDriverWait wait = BasePage.getWebDriverWait();
        Boolean elementInvisibility = (Boolean)wait.until((Function)ExpectedConditions.not((ExpectedCondition)ExpectedConditions.visibilityOf((WebElement)elementToWaitFor)));
        BFLogger.logTime((long)startTime, (String)"waitForElementNotVisible", (String)elementToWaitFor.toString());
        return elementInvisibility;
    }

    public static void dynamicClick(By selector) {
        BasePage.getDriver().waitUntilElementIsClickable(selector).click();
    }

    public static void moveMousePointer(int xOffset, int yOffset) {
        BasePage.getAction().moveByOffset(xOffset, yOffset).build().perform();
    }

    public static String getValue(WebElement field) {
        return field.getAttribute("value");
    }

    public static boolean isAttributeWithContent(String attribute, WebElement field) {
        return !StringUtils.isEmpty((CharSequence)field.getAttribute(attribute));
    }

    public static void sendNewKeys(WebElement field, String keys) {
        try {
            field.clear();
            field.sendKeys(new CharSequence[]{keys});
        }
        catch (InvalidElementStateException e) {
            throw new BFComponentStateException(field.toString(), "type '" + keys + "' into", "not editable.");
        }
    }

    public static <T> WebElement getExpectedElement(WebElement parent, By selector, Class<T> retriever, String expectedElementDescription) {
        WebElement e;
        try {
            e = parent.findElement(selector);
        }
        catch (NoSuchElementException ex) {
            throw new BFComponentStateException(retriever.getSimpleName(), "get " + expectedElementDescription, "not found");
        }
        return e;
    }

    public static boolean isElementOutdated(WebElement webElement) {
        try {
            webElement.getText();
        }
        catch (StaleElementReferenceException e) {
            return true;
        }
        return false;
    }

    public static boolean isLink(WebElement element) {
        return element.getAttribute("href") != null || element.getAttribute("url") != null;
    }

    public static void waitForAnimationEnd(By selector) {
        long startTime = System.currentTimeMillis();
        WebElement sliderElement = BasePage.getDriver().findElement(selector);
        String leftOffset = "";
        while (!leftOffset.equals(sliderElement.getAttribute("style"))) {
            if (System.currentTimeMillis() - startTime > DriverManager.EXPLICIT_WAIT.toMillis()) {
                throw new BFWaitingTimeoutException("Animation is to long", DriverManager.EXPLICIT_WAIT);
            }
            leftOffset = sliderElement.getAttribute("style");
            TimeUtills.waitMiliseconds(100);
        }
        BFLogger.logTime((long)startTime, (String)"waitForAnimationEnd", (String)selector.toString());
    }

    public static void clickIfVisible(By selector, String elementName) {
        if (!BasePage.isElementDisplayedNoException(selector)) {
            throw new BFComponentStateException(elementName, "click", "element not found");
        }
        BasePage.getDriver().findElement(selector).click();
    }

    public static List<String> getTexts(List<WebElement> elements) {
        ArrayList<String> result = new ArrayList<String>();
        for (WebElement element : elements) {
            result.add(element.getText());
        }
        return result;
    }
}

