/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.utils;

import com.capgemini.mrchecker.selenium.core.BasePage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class ParsingHelper {
    private ParsingHelper() {
    }

    public static int findAndParseIntFromWebElement(By by, boolean returnZeroIfContentIsNotParsable) {
        WebElement element = BasePage.getDriver().findElementDynamic(by);
        try {
            return ParsingHelper.parseInt(element.getText());
        }
        catch (NumberFormatException numberFormatException) {
            if (returnZeroIfContentIsNotParsable) {
                return 0;
            }
            throw numberFormatException;
        }
    }

    public static int parseInt(String stringToParse) {
        String stringToParseAfterFiltering = stringToParse.replaceAll("[^\\d-]|(\\d+-)", "");
        try {
            return Integer.parseInt(stringToParseAfterFiltering);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("For input string: \"" + stringToParse + "\"");
        }
    }

    public static String parseSubstring(String stringToParse, String regexToSearch) {
        Pattern pattern = Pattern.compile(regexToSearch);
        Matcher matcher = pattern.matcher(stringToParse);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return "";
    }

    public static String parseOptionSymbol(String symbol) {
        String optionSymbol = symbol;
        if (optionSymbol.startsWith("-")) {
            optionSymbol = symbol.replace("-", "");
            optionSymbol = optionSymbol.split("\\d")[0];
        }
        return optionSymbol;
    }
}

