/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.utils;

import com.capgemini.mrchecker.test.core.logger.BFLogger;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class OperationsOnFiles {
    private OperationsOnFiles() {
    }

    public static void moveWithPruneEmptydirectories(String source, String target) {
        try {
            Path sourcePath = FileSystems.getDefault().getPath(source, new String[0]);
            Path targetPath = FileSystems.getDefault().getPath(target, new String[0]);
            OperationsOnFiles.createDirectoryIfNotExists(targetPath);
            Files.move(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            OperationsOnFiles.removeFileAndParentsIfEmpty(sourcePath);
        }
        catch (IOException | NullPointerException e) {
            BFLogger.logError((String)("Unable to move file from: [" + source + "] to: [" + target + "]"));
        }
    }

    private static void createDirectoryIfNotExists(Path directoryPath) {
        Path targetDirPath = directoryPath.getParent();
        if (!Files.exists(targetDirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(targetDirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                BFLogger.logError((String)("Unable to create directories: [" + targetDirPath + "]."));
            }
        }
    }

    public static void removeFileAndParentsIfEmpty(Path path) throws IOException {
        if (path == null) {
            return;
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            Files.deleteIfExists(path);
            BFLogger.logInfo((String)("Deleted file - " + path.toAbsolutePath()));
        } else if (Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.delete(path);
                BFLogger.logInfo((String)("Deleted directory - " + path.toAbsolutePath()));
            }
            catch (FileSystemException e) {
                return;
            }
        }
        OperationsOnFiles.removeFileAndParentsIfEmpty(path.getParent());
    }
}

