/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.utils;

import com.capgemini.mrchecker.selenium.core.BasePage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebElement;

public class ImageUtils {
    private ImageUtils() {
    }

    public static BufferedImage readImageFromScreenShotOfElement(WebElement imageElement) throws IOException {
        if (!(BasePage.getDriver() instanceof JavascriptExecutor)) {
            return null;
        }
        ImageUtils.scrollPageToImage(imageElement, (JavascriptExecutor)BasePage.getDriver());
        return ImageUtils.getWebElementScreenshot(imageElement);
    }

    private static BufferedImage getWebElementScreenshot(WebElement we) throws IOException {
        File screenshotFile = (File)((TakesScreenshot)BasePage.getDriver()).getScreenshotAs(OutputType.FILE);
        BufferedImage fullImg = ImageIO.read(screenshotFile);
        BufferedImage webElementScreenshot = fullImg.getSubimage(we.getLocation().getX(), we.getLocation().getY() + 1, we.getSize().getWidth(), we.getSize().getHeight());
        BufferedImage webElementScreenshotWithAlfa = new BufferedImage(we.getSize().getWidth(), we.getSize().getHeight(), 2);
        for (int y = 0; y < we.getSize().getHeight(); ++y) {
            for (int x = 0; x < we.getSize().getWidth(); ++x) {
                int pixelColor = webElementScreenshot.getRGB(x, y);
                if (pixelColor == -1118482) {
                    pixelColor &= 0xFFFFFF;
                }
                webElementScreenshotWithAlfa.setRGB(x, y, pixelColor);
            }
        }
        ImageIO.write((RenderedImage)webElementScreenshotWithAlfa, "png", screenshotFile);
        FileUtils.copyFile((File)screenshotFile, (File)new File(System.getProperty("java.io.tmpdir").concat("subimage").concat("" + new Date().getTime()).concat(".png")));
        return webElementScreenshotWithAlfa;
    }

    private static void scrollPageToImage(WebElement webElement, JavascriptExecutor driver) {
        driver.executeScript(ImageUtils.buildScrollScript(webElement.getLocation()), new Object[0]);
    }

    private static String buildScrollScript(Point point) {
        return "window.scrollTo(" + point.x + "," + point.y + ");";
    }
}

