/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.utils;

import com.capgemini.mrchecker.selenium.core.BasePage;
import com.capgemini.mrchecker.selenium.core.enums.EdgesEnum;
import com.capgemini.mrchecker.selenium.core.enums.RelatedPositionEnum;
import com.capgemini.mrchecker.selenium.core.exceptions.BFElementNotFoundException;
import com.capgemini.mrchecker.selenium.core.newDrivers.DriverManager;
import com.capgemini.mrchecker.selenium.core.utils.ScrollUtils;
import com.capgemini.mrchecker.selenium.core.utils.WindowUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class ElementPositionUtils {
    private ElementPositionUtils() {
    }

    public static boolean isElementNextToEdge(WebElement element, EdgesEnum edge) {
        return element.getCssValue(edge.toString()).equals("0px");
    }

    public static boolean isElementsPositionRelatedX(By selectorFirst, By selectorSecond, RelatedPositionEnum position) {
        WebElement elementFirst = BasePage.getDriver().findElement(selectorFirst);
        WebElement elementSecond = BasePage.getDriver().findElement(selectorSecond);
        return ElementPositionUtils.isElementsPositionRelatedX(elementFirst, elementSecond, position);
    }

    public static boolean isElementsPositionRelatedY(By selectorFirst, By selectorSecond, RelatedPositionEnum position) {
        WebElement elementFirst = BasePage.getDriver().findElement(selectorFirst);
        WebElement elementSecond = BasePage.getDriver().findElement(selectorSecond);
        return ElementPositionUtils.isElementsPositionRelatedY(elementFirst, elementSecond, position);
    }

    public static boolean isElementsPositionRelatedX(By selectorFirst, By selectorSecond, WebElement scope, RelatedPositionEnum position) {
        WebElement elementFirst = BasePage.getDriver().findElementQuietly(scope, selectorFirst);
        WebElement elementSecond = BasePage.getDriver().findElementQuietly(scope, selectorSecond);
        if (elementFirst == null) {
            throw new BFElementNotFoundException(selectorFirst);
        }
        if (elementSecond == null) {
            throw new BFElementNotFoundException(selectorSecond);
        }
        return ElementPositionUtils.isElementsPositionRelatedX(elementFirst, elementSecond, position);
    }

    public static boolean isElementsPositionRelatedY(WebElement elementFirst, WebElement elementSecond, RelatedPositionEnum position) {
        int firstElementY = elementFirst.getLocation().getY();
        int secondElementY = elementSecond.getLocation().getY();
        if (position == RelatedPositionEnum.INLINE) {
            return firstElementY == secondElementY;
        }
        if (position == RelatedPositionEnum.ABOVE) {
            return firstElementY > secondElementY;
        }
        if (position == RelatedPositionEnum.BELOW) {
            return firstElementY < secondElementY;
        }
        return false;
    }

    public static boolean isElementsPositionRelatedX(WebElement elementFirst, WebElement elementSecond, RelatedPositionEnum position) {
        int firstElementX = elementFirst.getLocation().getX();
        int secondElementX = elementSecond.getLocation().getX();
        if (position == RelatedPositionEnum.INLINE) {
            return firstElementX == secondElementX;
        }
        if (position == RelatedPositionEnum.BEFORE) {
            return firstElementX > secondElementX;
        }
        if (position == RelatedPositionEnum.AFTER) {
            return firstElementX < secondElementX;
        }
        return false;
    }

    public static boolean isOnRightTopCorner(WebElement element) {
        ScrollUtils.scrollToTop();
        int elementPositonX = element.getLocation().getX();
        int screenWidthMiddle = WindowUtils.getScreenWidth(DriverManager.getDriver()) / 2;
        int elementPositonY = element.getLocation().getY() + element.getSize().getHeight();
        int screenHeightMiddle = WindowUtils.getScreenHeight(DriverManager.getDriver()) / 2;
        return elementPositonX >= screenWidthMiddle && elementPositonY <= screenHeightMiddle;
    }
}

