/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.utils;

import com.capgemini.mrchecker.selenium.core.utils.Utility;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DateUtils {
    public static final String TIME_12H_REGEX = "(1[012]|[1-9]):[0-5][0-9](\\s)?(?i) (AM|PM)";
    public static final String DATE_REGEX = "(0?[1-9]|1[012])/(0?[1-9]|[12][0-9]|3[01])/((19|20)\\d\\d)";
    public static final String AS_OF_TIMESTAMPT_REGEX = "(AS OF )(0?[1-9]|1[012])/(0?[1-9]|[12][0-9]|3[01])/((19|20)\\d\\d) (1[012]|[1-9]):[0-5][0-9](\\s)?(?i) (AM|PM)( ET)";
    public static final String COMMON_DATE_REGEX = "\\d{2}/\\d{2}/\\d{4}";
    public static final String US_DATE_FORMAT = "MM/dd/yyyy";
    public static final String[] MOTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String HTTP_RESPONSE_DATE_REGEX = "(\\w+,\\s\\d{1,2}\\s\\w+\\s\\d{4}\\s\\d{2}:\\d{2}:\\d{2}\\s\\w{2,6})";
    private static final String HTTP_RESPONSE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";

    private DateUtils() {
    }

    public static boolean matchDate(String date) {
        return DateUtils.matchDate(date, DATE_REGEX);
    }

    public static boolean matchDate(String date, String regex) {
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(date).matches();
    }

    public static boolean areDatesOrdered(List<Date> dates, Utility.SortOrder sortOrder) {
        if (dates.isEmpty()) {
            throw new IllegalArgumentException("Dates list can't be empty");
        }
        Date prevElDate = dates.get(0);
        for (Date elDate : dates) {
            if (prevElDate.compareTo(elDate) == sortOrder.param) {
                BFLogger.logDebug((String)("Dates are not sorted in " + StringUtils.lowerCase((String)sortOrder.toString()) + " order. First date: " + prevElDate + " second date: " + elDate));
                return false;
            }
            prevElDate = elDate;
        }
        return true;
    }

    public static int monthToNumber(String month) throws ParseException {
        Date date = null;
        date = new SimpleDateFormat("MMM").parse(month);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2);
    }

    public static Calendar convertStringToCalendar(String date) throws ParseException {
        SimpleDateFormat formater = new SimpleDateFormat(US_DATE_FORMAT);
        Date formattedDate = formater.parse(date);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(formattedDate);
        return calendar;
    }

    public static Calendar convertDateToCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static String getCurrentDateInUsFormat() {
        return DateUtils.getCurrentDate(US_DATE_FORMAT);
    }

    public static String getCurrentDate(String dateFormatStr) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatStr);
        return dateFormat.format(new Date());
    }

    public static boolean containsDate(String toCheck) {
        String datePattern = COMMON_DATE_REGEX;
        Pattern p = Pattern.compile(datePattern);
        Matcher matcher = p.matcher(toCheck);
        return matcher.find();
    }

    public static int compareDatesWithoutTime(Date date1, Date date2) {
        Calendar c1 = DateUtils.convertDateToCalendar(date1);
        Calendar c2 = DateUtils.convertDateToCalendar(date2);
        if (c1.get(1) != c2.get(1)) {
            return c1.get(1) - c2.get(1);
        }
        if (c1.get(2) != c2.get(2)) {
            return c1.get(2) - c2.get(2);
        }
        return c1.get(5) - c2.get(5);
    }

    public static Calendar getFirstDateFromString(String text) throws ParseException {
        Matcher matcher = Pattern.compile(COMMON_DATE_REGEX).matcher(text);
        matcher.find();
        return DateUtils.convertStringToCalendar(matcher.group());
    }
}

