/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.newDrivers.elementType;

import com.capgemini.mrchecker.selenium.core.exceptions.BFElementNotFoundException;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.BasicElement;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.ElementType;
import com.capgemini.mrchecker.test.core.exceptions.BFInputDataException;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class NavigationBarElement
extends BasicElement {
    private final By inputChildsSelector;

    public NavigationBarElement(By cssSelector) {
        this(cssSelector, By.cssSelector((String)"li"));
    }

    public NavigationBarElement(By cssSelector, By inputChildsSelector) {
        super(ElementType.NAVIGATION_BAR, cssSelector);
        this.inputChildsSelector = inputChildsSelector;
    }

    public List<String> getItemsTextList() {
        List<WebElement> listElems = this.getItems();
        ArrayList<String> out = new ArrayList<String>();
        for (WebElement listElem : listElems) {
            out.add(listElem.getText());
        }
        return out;
    }

    public String getFirstItemText() {
        return this.getItemsTextList().get(0);
    }

    public String getActiveItemText() {
        List<WebElement> listItems = this.getItems();
        for (WebElement listItem : listItems) {
            if (!listItem.getAttribute("class").contains("active")) continue;
            return listItem.getText();
        }
        throw new BFElementNotFoundException("Any active item was found in " + this.getElement().toString());
    }

    public void clickFirstItem() {
        this.getItems().get(0).click();
    }

    public void clickActiveItem() {
        this.getItems().get(this.getDepth() - 1).click();
    }

    public void clickItemByIndex(int index) {
        if (index > 0 && index >= this.getItems().size()) {
            throw new BFInputDataException("Index " + index + " larger than list's size: " + this.getItems().size());
        }
        this.getItems().get(index).click();
    }

    public void clickItemByText(String text) {
        for (int i = 0; i < this.getItems().size(); ++i) {
            if (!this.getItems().get(i).getText().equals(text)) continue;
            this.getItems().get(i).click();
            return;
        }
        throw new BFElementNotFoundException("Item with text: " + text + " wasn't found in " + this.getText());
    }

    public int getDepth() {
        return this.getItems().size();
    }

    private List<WebElement> getItems() {
        return this.getElement().findElements(this.inputChildsSelector);
    }
}

