/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.newDrivers.elementType;

import com.capgemini.mrchecker.selenium.core.BasePage;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.BasicElement;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.ElementType;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import java.math.BigDecimal;
import java.math.MathContext;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

public class HorizontalSliderElement
extends BasicElement {
    public static final int KEYBOARD = 0;
    public static final int MOUSE = 1;
    private static final int MOUSE_MOVE_LEFT = 0;
    private static final int MOUSE_MOVE_RIGHT = 1;
    private BigDecimal minRange;
    private BigDecimal maxRange;
    private BigDecimal step = BigDecimal.ONE;
    private int maxNumberOfSteps;
    private By sliderSelector;
    private By valueSelector;

    public HorizontalSliderElement(By sliderContainerSelector) {
        super(ElementType.HORIZONTAL_SLIDER, sliderContainerSelector);
    }

    public HorizontalSliderElement(By sliderContainerSelector, By sliderSelector, By valueSelector) {
        this(sliderContainerSelector);
        this.sliderSelector = sliderSelector;
        this.valueSelector = valueSelector;
    }

    public HorizontalSliderElement(By sliderContainerSelector, By sliderSelector, By valueSelector, BigDecimal minRange, BigDecimal maxRange, BigDecimal step) {
        this(sliderContainerSelector);
        this.sliderSelector = sliderSelector;
        this.valueSelector = valueSelector;
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.step = step;
        this.maxNumberOfSteps = this.calculateMaxNumberOfSteps();
    }

    public BigDecimal getCurrentSliderValue() throws NumberFormatException {
        WebElement currentValueElement = this.getElement().findElement(this.valueSelector);
        String value = currentValueElement.getText();
        if (value == null || value.isEmpty()) {
            value = this.getValueAttributeOfWebElement(currentValueElement);
        }
        return new BigDecimal(value);
    }

    public BigDecimal getMinRange() {
        return this.minRange;
    }

    public void setMinRange(BigDecimal minRange) {
        this.minRange = minRange;
    }

    public BigDecimal getMaxRange() {
        return this.maxRange;
    }

    public void setMaxRange(BigDecimal maxRange) {
        this.maxRange = maxRange;
    }

    public BigDecimal getStep() {
        return this.step;
    }

    public void setStep(BigDecimal step) {
        this.step = step;
    }

    public int getMaxNumberOfSteps() {
        return this.maxNumberOfSteps;
    }

    public Dimension getDimensions() {
        return this.getElement().findElement(this.sliderSelector).getSize();
    }

    public Integer getWidth() {
        return this.getDimensions().getWidth();
    }

    public BigDecimal getStepWidth() {
        BigDecimal rangeDiff = this.maxRange.subtract(this.minRange);
        BigDecimal numberOfSteps = rangeDiff.setScale(1).divide(this.step.setScale(1));
        return new BigDecimal(this.getWidth()).divide(numberOfSteps);
    }

    public void setSliderPositionTo(BigDecimal position, int method) {
        String message = "Chosen method doesn't exist.";
        BasePage.getDriver().mouseLeftClick(this.getElement().findElement(this.sliderSelector));
        position = this.verifyAndCorrectPositionValue(position);
        block8: for (int counter = 0; position.compareTo(this.getCurrentSliderValue()) != 0 || counter > this.getMaxNumberOfSteps(); ++counter) {
            if (position.compareTo(this.getCurrentSliderValue()) > 0) {
                switch (method) {
                    case 0: {
                        this.performKeypress((CharSequence)Keys.ARROW_RIGHT);
                        break;
                    }
                    case 1: {
                        this.performMouseMove(1);
                        break;
                    }
                    default: {
                        BFLogger.logDebug((String)(message + method));
                        break;
                    }
                }
                continue;
            }
            if (position.compareTo(this.getCurrentSliderValue()) >= 0) continue;
            switch (method) {
                case 0: {
                    this.performKeypress((CharSequence)Keys.ARROW_LEFT);
                    continue block8;
                }
                case 1: {
                    this.performMouseMove(0);
                    continue block8;
                }
                default: {
                    BFLogger.logDebug((String)(message + method));
                }
            }
        }
    }

    public BigDecimal verifyAndCorrectPositionValue(BigDecimal position) {
        if (position.compareTo(this.getMinRange()) < 0) {
            BFLogger.logInfo((String)("Position value: " + position + " will be set to minimum value: " + this.getMinRange()));
            position = this.getMinRange();
        } else if (position.compareTo(this.getMaxRange()) > 0) {
            BFLogger.logInfo((String)("Position value: " + position + " will be set to maximum value: " + this.getMaxRange()));
            position = this.getMaxRange();
        }
        BigDecimal step = this.getStep();
        BigDecimal rest = position.remainder(step);
        if (rest.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal oldPosition = position;
            BigDecimal sub = step.subtract(rest);
            int result = sub.compareTo(rest);
            switch (result) {
                case -1: 
                case 0: {
                    position = position.add(sub, new MathContext(step.scale() + 1));
                    break;
                }
                case 1: {
                    position = position.subtract(rest, new MathContext(step.scale() + 1));
                    break;
                }
            }
            if (position.scale() > 0) {
                position = position.stripTrailingZeros();
            }
            BFLogger.logInfo((String)("Position value: " + oldPosition + " must be a multiply of " + step + ". It will be rounded to: " + position));
        }
        return position;
    }

    private String getValueAttributeOfWebElement(WebElement element) {
        return element.getAttribute("value");
    }

    private int calculateMaxNumberOfSteps() {
        return this.getMaxRange().subtract(this.getMinRange()).divide(this.getStep()).intValueExact();
    }

    private void performKeypress(CharSequence key) {
        BasePage.getAction().sendKeys(new CharSequence[]{key}).build().perform();
    }

    private void performMouseMove(int side) {
        int offset = this.getStepWidth().intValue();
        if (side == 0) {
            offset = -offset;
        }
        BasePage.getAction().clickAndHold().moveByOffset(offset, 0).release().build().perform();
    }
}

