/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.newDrivers.elementType;

import com.capgemini.mrchecker.selenium.core.exceptions.BFComponentStateException;
import com.capgemini.mrchecker.selenium.core.exceptions.BFElementNotFoundException;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.BasicElement;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.ElementType;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class CheckBox
extends BasicElement {
    private By inputChildsSelector;

    public CheckBox(By cssSelector) {
        this(cssSelector, By.cssSelector((String)"input"));
    }

    public CheckBox(By cssSelector, By inputChildsSelector) {
        super(ElementType.CHECKBOX, cssSelector);
        this.setInputChildsSelector(inputChildsSelector);
    }

    public void setCheckBoxByIndex(int index) {
        this.setCheckBoxByIndexTo(index, true);
    }

    public void setCheckBoxByValue(String value) {
        this.setCheckBoxByValueTo(value, true);
    }

    public void setCheckBoxByText(String text) {
        this.setCheckBoxByTextTo(text, true);
    }

    public void unsetCheckBoxByIndex(int index) {
        this.setCheckBoxByIndexTo(index, false);
    }

    public void unsetCheckBoxByValue(String value) {
        this.setCheckBoxByValueTo(value, false);
    }

    public void unsetCheckBoxByText(String text) {
        this.setCheckBoxByTextTo(text, false);
    }

    public void setAllCheckBoxes() {
        this.setAllCheckBoxesTo(true);
    }

    public void unsetAllCheckBoxes() {
        this.setAllCheckBoxesTo(false);
    }

    public boolean isCheckBoxSetByIndex(int index) {
        return this.getCheckBoxesList().get(index).isSelected();
    }

    public boolean isCheckBoxSetByValue(String value) {
        return this.getCheckBoxesList().get(this.getCheckBoxIndexByValue(value)).isSelected();
    }

    public boolean isCheckBoxSetByText(String text) {
        return this.getCheckBoxesList().get(this.getCheckBoxIndexByText(text)).isSelected();
    }

    public boolean isAllCheckboxesSet() {
        return this.isAllCheckBoxesSetTo(true);
    }

    public List<String> getTextList() {
        return Arrays.asList(this.getText().split("\n"));
    }

    private List<WebElement> getCheckBoxesList() {
        return this.getElement().findElements(this.inputChildsSelector);
    }

    private void setCheckBoxByIndexTo(int index, boolean destination) {
        boolean currentState;
        if (this.getCheckBoxesList().get(index).isSelected() != destination) {
            this.getCheckBoxesList().get(index).click();
        }
        if ((currentState = this.getCheckBoxesList().get(index).isSelected()) != destination) {
            throw new BFComponentStateException(ElementType.CHECKBOX.toString(), "set/unset", String.valueOf(currentState));
        }
    }

    private void setCheckBoxByValueTo(String value, boolean destination) {
        this.setCheckBoxToByAttribute(value, destination);
    }

    private void setCheckBoxByTextTo(String text, boolean destination) {
        this.setCheckBoxByIndexTo(this.getCheckBoxIndexByText(text), destination);
    }

    private int getCheckBoxIndexByText(String text) {
        List<String> textsList = this.getTextList();
        for (int i = 0; i < textsList.size(); ++i) {
            if (!textsList.get(i).equals(text.trim())) continue;
            return i;
        }
        throw new BFElementNotFoundException("Checkbox with text " + text + " wasn't found.");
    }

    private int getCheckBoxIndexByValue(String value) {
        List<WebElement> checkBoxesList = this.getCheckBoxesList();
        for (int i = 0; i < checkBoxesList.size(); ++i) {
            if (!checkBoxesList.get(i).getAttribute("value").equals(value.trim())) continue;
            return i;
        }
        throw new BFElementNotFoundException("Checkbox with value " + value + " wasn't found.");
    }

    private void setCheckBoxToByAttribute(String value, boolean destination) {
        List<WebElement> checkboxesList = this.getCheckBoxesList();
        for (WebElement webElement : checkboxesList) {
            WebElement currentElement = webElement;
            if (!currentElement.getAttribute("value").equals(value) || currentElement.isSelected() == destination) continue;
            currentElement.click();
        }
    }

    private void setAllCheckBoxesTo(boolean destination) {
        List<WebElement> checkboxesList = this.getCheckBoxesList();
        for (WebElement webElement : checkboxesList) {
            if (webElement.isSelected() == destination) continue;
            webElement.click();
        }
        if (!this.isAllCheckBoxesSetTo(destination)) {
            throw new BFComponentStateException(ElementType.CHECKBOX.toString(), "set/unset", "setting to " + destination);
        }
    }

    private boolean isAllCheckBoxesSetTo(boolean destination) {
        List<WebElement> checkboxesList = this.getCheckBoxesList();
        for (WebElement webElement : checkboxesList) {
            if (webElement.isSelected() == destination) continue;
            return false;
        }
        return true;
    }

    private void setInputChildsSelector(By selector) {
        this.inputChildsSelector = selector;
    }
}

