/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.newDrivers.elementType;

import com.capgemini.mrchecker.selenium.core.BasePage;
import com.capgemini.mrchecker.selenium.core.exceptions.BFElementNotFoundException;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.ElementType;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.IBasicElement;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public abstract class BasicElement
implements IBasicElement {
    private final ElementType type;
    private By cssSelector;

    public BasicElement(ElementType type, By cssSelector) {
        this.type = type;
        this.setCssSelector(cssSelector);
        this.load();
    }

    @Override
    public WebElement load() {
        return this.getElement();
    }

    @Override
    public String getElementTypeName() {
        return this.type.toString();
    }

    public WebElement getElement() throws BFElementNotFoundException {
        return BasePage.getDriver().findElementDynamic(this.getCssSelector());
    }

    public String getClassName() {
        return this.getElement().getAttribute("class");
    }

    public String getValue() {
        return this.getElement().getAttribute("value");
    }

    public String getText() {
        return this.getElement().getText();
    }

    public Boolean isDisplayed() {
        return BasePage.isElementDisplayed(this.getCssSelector());
    }

    private By getCssSelector() {
        return this.cssSelector;
    }

    private void setCssSelector(By cssSelector) {
        this.cssSelector = cssSelector;
    }
}

