/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.newDrivers;

import com.capgemini.mrchecker.selenium.core.base.runtime.RuntimeParametersSelenium;
import com.capgemini.mrchecker.selenium.core.exceptions.BFComponentStateException;
import com.capgemini.mrchecker.selenium.core.exceptions.BFElementNotFoundException;
import com.capgemini.mrchecker.selenium.core.newDrivers.DriverManager;
import com.capgemini.mrchecker.selenium.core.utils.TimeUtills;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementClickInterceptedException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.UselessFileDetector;

public class NewRemoteWebElement
extends RemoteWebElement {
    private static final int CLICK_NUM = 10;
    private static final int MICRO_SLEEP = 200;
    private static final Pattern foundByPattern = Pattern.compile("\\[\\[.* -> (.*): (.*)\\]");
    private static boolean clickTimerOn = false;
    private static long totalClickTime;
    private static long startClickTime;
    private static FileDetector newRemoteElementFileDetector;
    private static final Semaphore configureFileDetectorSemaphore;

    public NewRemoteWebElement(WebElement element) {
        RemoteWebElement remoteWebElement = (RemoteWebElement)element;
        this.id = remoteWebElement.getId();
        this.setParent((RemoteWebDriver)remoteWebElement.getWrappedDriver());
        this.configureFileDetector();
        Matcher remoteWebElementInfo = foundByPattern.matcher(remoteWebElement.toString());
        if (remoteWebElementInfo.matches()) {
            this.setFoundBy((SearchContext)element, remoteWebElementInfo.group(1), remoteWebElementInfo.group(2));
        } else {
            BFLogger.logError((String)("Incorrect FoundBy form WebElement " + remoteWebElement.toString()));
        }
    }

    public static void setClickTimer() {
        clickTimerOn = true;
        totalClickTime = 0L;
    }

    public static long dropClickTimer() {
        clickTimerOn = false;
        return totalClickTime;
    }

    private void configureFileDetector() {
        try {
            configureFileDetectorSemaphore.acquire();
            if (!Objects.isNull(newRemoteElementFileDetector)) {
                this.fileDetector = newRemoteElementFileDetector;
            } else {
                newRemoteElementFileDetector = this.fileDetector = NewRemoteWebElement.isRemoteGrid() ? new LocalFileDetector() : new UselessFileDetector();
                BFLogger.logDebug((String)("FileDetector for all NewRemoteWebElements will be set to " + this.fileDetector.getClass().getCanonicalName()));
            }
            configureFileDetectorSemaphore.release();
        }
        catch (InterruptedException e) {
            BFLogger.logError((String)"FileDetector could not be set. The default will be used");
        }
    }

    private static boolean isRemoteGrid() {
        String gridHost = RuntimeParametersSelenium.SELENIUM_GRID.getValue().trim();
        return DriverManager.getDriver().getClass().getSimpleName().equals("NewRemoteWebDriver") && !gridHost.startsWith("http://127.0.0.1") && !gridHost.startsWith("http://localhost");
    }

    @Deprecated
    public WebElement findElement(By by) throws BFElementNotFoundException {
        WebElement element = null;
        try {
            element = super.findElement(by);
        }
        catch (NoSuchElementException e) {
            throw new BFElementNotFoundException(by);
        }
        return new NewRemoteWebElement(element);
    }

    @Deprecated
    public List<WebElement> findElements(By by) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (WebElement element : super.findElements(by)) {
            elements.add((WebElement)new NewRemoteWebElement(element));
        }
        return elements;
    }

    public void click() throws StaleElementReferenceException {
        block5: {
            if (clickTimerOn) {
                startClickTime = System.currentTimeMillis();
            }
            try {
                super.click();
            }
            catch (ElementClickInterceptedException e) {
                SelectorComponents selectorComponents = new SelectorComponents(this.toString());
                throw new BFComponentStateException(selectorComponents.getTerm(), "click", "not visible");
            }
            catch (StaleElementReferenceException e) {
                By selector = this.getSelector();
                if (selector == null) {
                    this.calculateClickTime();
                    throw e;
                }
                if (this.click(selector, 10)) break block5;
                this.calculateClickTime();
                throw e;
            }
        }
        this.calculateClickTime();
    }

    private void calculateClickTime() {
        if (clickTimerOn) {
            totalClickTime += System.currentTimeMillis() - startClickTime;
        }
    }

    private boolean click(By selector, int callNum) {
        try {
            TimeUtills.waitMiliseconds(200);
            this.getWrappedDriver().findElement(selector).click();
            return true;
        }
        catch (StaleElementReferenceException e) {
            if (callNum > 0) {
                return this.click(selector, callNum - 1);
            }
            return false;
        }
    }

    private By getSelector() {
        String locator;
        SelectorComponents selectorComponents = new SelectorComponents(this.toString());
        String term = selectorComponents.getTerm();
        if (term == null) {
            BFLogger.logError((String)"Selector is not defined");
            return null;
        }
        By.ByClassName selector = null;
        switch (locator = selectorComponents.getLocator()) {
            case "className selector": {
                selector = new By.ByClassName(term);
                break;
            }
            case "css selector": {
                selector = new By.ByCssSelector(term);
                break;
            }
            case "id selector": {
                selector = new By.ById(term);
                break;
            }
            case "linkText selector": {
                selector = new By.ByLinkText(term);
                break;
            }
            case "name selector": {
                selector = new By.ByName(term);
                break;
            }
            case "partialLinkText selector": {
                selector = new By.ByPartialLinkText(term);
                break;
            }
            case "tagName selector": {
                selector = new By.ByTagName(term);
                break;
            }
            case "xpath selector": {
                selector = new By.ByXPath(term);
            }
        }
        BFLogger.logError((String)String.format("Locator '%s' not found", locator));
        return selector;
    }

    static {
        configureFileDetectorSemaphore = new Semaphore(1);
    }

    private class SelectorComponents {
        String locator = null;
        String term = null;

        SelectorComponents(String elementInfo) {
            Matcher thisWebElementInfo = foundByPattern.matcher(elementInfo);
            if (!thisWebElementInfo.matches()) {
                BFLogger.logError((String)String.format("Selector not found from '%s', pattern error.", elementInfo));
                return;
            }
            this.locator = thisWebElementInfo.group(1);
            this.term = thisWebElementInfo.group(2);
        }

        String getLocator() {
            return this.locator;
        }

        String getTerm() {
            return this.term;
        }
    }
}

