/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core.newDrivers;

import com.capgemini.mrchecker.selenium.core.BasePage;
import com.capgemini.mrchecker.selenium.core.exceptions.BFElementNotFoundException;
import com.capgemini.mrchecker.selenium.core.newDrivers.DriverManager;
import com.capgemini.mrchecker.selenium.core.newDrivers.INewWebDriver;
import com.capgemini.mrchecker.selenium.core.newDrivers.NewRemoteWebElement;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.Button;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.CheckBox;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.DropdownListElement;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.HorizontalSliderElement;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.IFrame;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.ImageElement;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.InputTextElement;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.LabelElement;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.ListElements;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.MenuElement;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.NavigationBarElement;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.RadioButtonElement;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.TabElement;
import com.capgemini.mrchecker.selenium.core.newDrivers.elementType.TooltipElement;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.WebDriverWait;

public class DriverExtension {
    private INewWebDriver driver;

    public DriverExtension(INewWebDriver driver) {
        this.setDriver(driver);
    }

    public INewWebDriver getDriver() {
        return this.driver;
    }

    public WebElement findElementQuietly(By by) {
        return this.findElementQuietly(null, by);
    }

    public WebElement findElementQuietly(WebElement elementToSearchIn, By by) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        WebElement element = null;
        try {
            element = Objects.isNull(elementToSearchIn) ? this.getDriver().findElement(by) : new NewRemoteWebElement(elementToSearchIn).findElement(by);
        }
        catch (NoSuchElementException e) {
            BFLogger.logError((String)("Element [" + by.toString() + "] was not found in given element"));
        }
        return element;
    }

    public WebElement findElementDynamic(By by) throws BFElementNotFoundException {
        long startTime = System.currentTimeMillis();
        return this.findElementDynamicBasic(by, startTime);
    }

    public WebElement findElementDynamic(By by, Duration timeOut) throws BFElementNotFoundException {
        long startTime = System.currentTimeMillis();
        return this.findElementDynamicBasic(by, startTime, timeOut);
    }

    public WebElement findElementDynamic(WebElement elementToSearchIn, By by) throws BFElementNotFoundException {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        long startTime = System.currentTimeMillis();
        return Objects.isNull(elementToSearchIn) ? this.findElementDynamic(by) : this.findElementDynamicBasic(by, startTime);
    }

    private WebElement findElementDynamicBasic(By by, long startTime) throws BFElementNotFoundException {
        return this.findElementDynamicBasic(by, startTime, DriverManager.EXPLICIT_WAIT);
    }

    private WebElement findElementDynamicBasic(By by, long startTime, Duration timeOut) throws BFElementNotFoundException {
        WebElement element;
        WebDriverWait wait = this.webDriverWait(timeOut);
        try {
            element = (WebElement)wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)by));
        }
        catch (NoSuchElementException | TimeoutException e) {
            boolean isTimeout = true;
            throw new BFElementNotFoundException(by, isTimeout, timeOut);
        }
        BFLogger.logTime((long)startTime, (String)"findElementDynamic()", (String)by.toString());
        return element;
    }

    public List<WebElement> findElementsDynamic(By by, Duration timeOut) throws BFElementNotFoundException {
        List elements;
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        long startTime = System.currentTimeMillis();
        WebDriverWait wait = this.webDriverWait(timeOut);
        try {
            elements = (List)wait.until((Function)ExpectedConditions.presenceOfAllElementsLocatedBy((By)by));
        }
        catch (BFElementNotFoundException | TimeoutException e) {
            throw new BFElementNotFoundException(by, true, timeOut);
        }
        if (elements.isEmpty()) {
            BFLogger.logError((String)("Not found element : " + by.toString() + "."));
        }
        BFLogger.logTime((long)startTime, (String)"findElementDynamics()", (String)by.toString());
        return elements;
    }

    public List<WebElement> findElementsDynamic(By by) throws BFElementNotFoundException {
        return this.findElementsDynamic(by, DriverManager.EXPLICIT_WAIT);
    }

    public WebElement waitForElement(By by) throws BFElementNotFoundException {
        WebElement element;
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        long startTime = System.currentTimeMillis();
        FluentWait wait = new FluentWait((Object)this.driver);
        wait.pollingEvery(Duration.ofMillis(250L));
        wait.withTimeout(Duration.ofMinutes(2L));
        try {
            element = (WebElement)this.webDriverWait().until(driver -> driver.findElement(by));
        }
        catch (NoSuchElementException | TimeoutException e) {
            boolean isTimeout = true;
            throw new BFElementNotFoundException(by, isTimeout, DriverManager.EXPLICIT_WAIT);
        }
        BFLogger.logTime((long)startTime, (String)"waitForElement()", (String)by.toString());
        return element;
    }

    public WebElement waitUntilElementIsClickable(By by) {
        WebElement element;
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        long startTime = System.currentTimeMillis();
        try {
            element = (WebElement)this.webDriverWait().until((Function)ExpectedConditions.elementToBeClickable((By)by));
        }
        catch (NoSuchElementException | TimeoutException e) {
            boolean isTimeout = true;
            throw new BFElementNotFoundException(by, isTimeout, DriverManager.EXPLICIT_WAIT);
        }
        BFLogger.logTime((long)startTime, (String)"waitUntilElementIsClickable()", (String)by.toString());
        return element;
    }

    public WebElement waitForElementVisible(By by) throws BFElementNotFoundException {
        WebElement element;
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        long startTime = System.currentTimeMillis();
        try {
            element = (WebElement)this.webDriverWait().until((Function)ExpectedConditions.visibilityOfElementLocated((By)by));
        }
        catch (NoSuchElementException | TimeoutException e) {
            boolean isTimeout = true;
            throw new BFElementNotFoundException(by, isTimeout, DriverManager.EXPLICIT_WAIT);
        }
        BFLogger.logTime((long)startTime, (String)"waitForElementVisible()", (String)by.toString());
        return element;
    }

    public void waitForPageLoaded() throws BFElementNotFoundException {
        long startTime = System.currentTimeMillis();
        String jsVariable = "return document.readyState";
        ExpectedCondition expectation = driver -> ((JavascriptExecutor)driver).executeScript("return document.readyState", new Object[0]).equals("complete");
        Duration progressBarWaitTimer = BasePage.PROGRESS_BAR_WAIT_TIMER;
        WebDriverWait wait = this.webDriverWait(progressBarWaitTimer);
        try {
            wait.until((Function)expectation);
        }
        catch (NoSuchElementException | TimeoutException e) {
            boolean isTimeout = true;
            throw new BFElementNotFoundException(By.cssSelector((String)"return document.readyState"), isTimeout, progressBarWaitTimer);
        }
        BFLogger.logTime((long)startTime, (String)"waitForPageLoaded");
    }

    private void setDriver(INewWebDriver driver) {
        this.driver = driver;
    }

    private WebDriverWait webDriverWait() {
        return this.webDriverWait(DriverManager.EXPLICIT_WAIT);
    }

    private WebDriverWait webDriverWait(Duration timeOut) {
        return new WebDriverWait((WebDriver)this.getDriver(), timeOut);
    }

    static List<WebElement> convertWebElementList(List<WebElement> elementList) {
        ArrayList<WebElement> elementsList = new ArrayList<WebElement>();
        for (WebElement element : elementList) {
            elementsList.add((WebElement)new NewRemoteWebElement(element));
        }
        return elementsList;
    }

    public Button elementButton(By selector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new Button(selector);
    }

    public RadioButtonElement elementRadioButton(By selector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new RadioButtonElement(selector);
    }

    public RadioButtonElement elementRadioButton(By selector, By childs) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new RadioButtonElement(selector, childs);
    }

    public RadioButtonElement elementRadioButton(By selector, By childs, List<String> selectedAttributes) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new RadioButtonElement(selector, childs, selectedAttributes);
    }

    public InputTextElement elementInputText(By selector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new InputTextElement(selector);
    }

    public DropdownListElement elementDropdownList(By selector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new DropdownListElement(selector);
    }

    public ListElements elementList(By selector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new ListElements(selector);
    }

    public CheckBox elementCheckbox(By selector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new CheckBox(selector);
    }

    public CheckBox elementCheckbox(By selector, By childs) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new CheckBox(selector, childs);
    }

    public LabelElement elementLabel(By selector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new LabelElement(selector);
    }

    public TabElement elementTab(By selector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new TabElement(selector);
    }

    public TabElement elementTab(By selector, By childs) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new TabElement(selector, childs);
    }

    public TabElement elementTab(By selector, By childs, List<String> selectedAttributes) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new TabElement(selector, childs, selectedAttributes);
    }

    public NavigationBarElement elementNavigationBar(By selector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new NavigationBarElement(selector);
    }

    public NavigationBarElement elementNavigationBar(By selector, By inputChildsSelector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new NavigationBarElement(selector, inputChildsSelector);
    }

    public TooltipElement elementTooltip(By selector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new TooltipElement(selector);
    }

    public MenuElement elementMenu(By selector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new MenuElement(selector);
    }

    public MenuElement elementMenu(By selector, By childsSelector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new MenuElement(selector, childsSelector);
    }

    public MenuElement elementMenu(By selector, By childsSelector, By subMenuSelector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new MenuElement(selector, childsSelector, subMenuSelector);
    }

    public MenuElement elementMenu(By selector, By childsSelector, By subMenuSelector, By childsSubMenuSelector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new MenuElement(selector, childsSelector, subMenuSelector, childsSubMenuSelector);
    }

    public HorizontalSliderElement elementHorizontalSlider(By sliderContainerSelector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new HorizontalSliderElement(sliderContainerSelector);
    }

    public HorizontalSliderElement elementHorizontalSlider(By sliderContainerSelector, By sliderSelector, By valueSelector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new HorizontalSliderElement(sliderContainerSelector, sliderSelector, valueSelector);
    }

    public HorizontalSliderElement elementHorizontalSlider(By sliderContainerSelector, By sliderSelector, By valueSelector, BigDecimal minRange, BigDecimal maxRange, BigDecimal step) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new HorizontalSliderElement(sliderContainerSelector, sliderSelector, valueSelector, minRange, maxRange, step);
    }

    public IFrame elementIFrame(By selector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new IFrame(selector);
    }

    public ImageElement elementImage(By selector) {
        BasePage.getAnalytics().sendMethodEvent("Selenium-NewDrivers");
        return new ImageElement(selector);
    }

    public void mouseRightClick(By selector) {
        WebElement element = this.findElementDynamic(selector);
        Actions action = new Actions((WebDriver)this.getDriver()).contextClick(element);
        action.build().perform();
    }

    public void mouseLeftClick(By selector) {
        WebElement element = this.getDriver().findElementQuietly(selector);
        if (element != null) {
            this.mouseLeftClick(element);
        } else {
            BFLogger.logDebug((String)"Unable to perform left mouse click due to null WebElement");
        }
    }

    public void mouseLeftClick(WebElement element) {
        new Actions((WebDriver)this.getDriver()).click(element).build().perform();
    }
}

