/*
 * Decompiled with CFR 0.152.
 */
package com.capgemini.mrchecker.selenium.core;

import com.capgemini.mrchecker.selenium.core.IBasePage;
import com.capgemini.mrchecker.selenium.core.base.properties.PropertiesSelenium;
import com.capgemini.mrchecker.selenium.core.base.runtime.RuntimeParametersSelenium;
import com.capgemini.mrchecker.selenium.core.exceptions.BFElementNotFoundException;
import com.capgemini.mrchecker.selenium.core.newDrivers.DriverManager;
import com.capgemini.mrchecker.selenium.core.newDrivers.INewWebDriver;
import com.capgemini.mrchecker.selenium.core.utils.WindowUtils;
import com.capgemini.mrchecker.test.core.BaseTest;
import com.capgemini.mrchecker.test.core.ModuleType;
import com.capgemini.mrchecker.test.core.Page;
import com.capgemini.mrchecker.test.core.analytics.IAnalytics;
import com.capgemini.mrchecker.test.core.base.environment.IEnvironmentService;
import com.capgemini.mrchecker.test.core.base.properties.PropertiesSettingsModule;
import com.capgemini.mrchecker.test.core.logger.BFLogger;
import com.google.inject.Guice;
import com.google.inject.Module;
import io.qameta.allure.Attachment;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.WebDriverWait;

public abstract class BasePage
extends Page
implements IBasePage {
    public static final Duration EXPLICIT_SHORT_WAIT_TIME = Duration.ofSeconds(1L);
    public static final Duration PROGRESS_BAR_WAIT_TIMER = Duration.ofSeconds(60L);
    public static final int MAX_COMPONENT_RELOAD_COUNT = 3;
    private static DriverManager driverManager = null;
    private BasePage parent;
    private static IEnvironmentService environmentService;
    private static final IAnalytics ANALYTICS;
    public static final String ANALYTICS_CATEGORY_NAME = "Selenium-NewDrivers";
    private static final PropertiesSelenium PROPERTIES_SELENIUM;

    public static IAnalytics getAnalytics() {
        return ANALYTICS;
    }

    public BasePage() {
        this(null);
    }

    public BasePage(BasePage parent) {
        this.setParent(parent);
        if (!this.isLoaded()) {
            this.load();
        }
    }

    public void onTestFailure() {
        super.onTestFailure();
        this.makeScreenshotOnFailure();
        this.makeSourcePageOnFailure();
    }

    public void onTestClassFinish() {
        super.onTestClassFinish();
        DriverManager.closeDriver();
    }

    public ModuleType getModuleType() {
        return ModuleType.SELENIUM;
    }

    @Attachment(value="Screenshot on failure")
    public byte[] makeScreenshotOnFailure() {
        byte[] screenshot = null;
        try {
            screenshot = (byte[])((TakesScreenshot)DriverManager.getDriver()).getScreenshotAs(OutputType.BYTES);
        }
        catch (UnhandledAlertException e) {
            BFLogger.logDebug((String)"[makeScreenshotOnFailure] Unable to take screenshot.");
        }
        return screenshot;
    }

    @Attachment(value="Source Page on failure")
    public String makeSourcePageOnFailure() {
        return DriverManager.getDriver().getPageSource();
    }

    public String getActualPageTitle() {
        return BasePage.getDriver().getTitle();
    }

    public void refreshPage() {
        BasePage.getDriver().navigate().refresh();
    }

    public static INewWebDriver getDriver() {
        if (Objects.isNull(driverManager)) {
            driverManager = new DriverManager(PROPERTIES_SELENIUM);
        }
        return driverManager.getDriver();
    }

    public static INewWebDriver getDriver(MutableCapabilities options) {
        if (Objects.isNull(driverManager)) {
            driverManager = new DriverManager(PROPERTIES_SELENIUM);
        }
        return DriverManager.getDriver(options);
    }

    public static void navigateBack() {
        BasePage.getDriver().navigate().back();
        BasePage.getDriver().waitForPageLoaded();
    }

    public static Actions getAction() {
        return new Actions((WebDriver)BasePage.getDriver());
    }

    @Override
    public void setParent(BasePage parent) {
        this.parent = parent;
    }

    @Override
    public BasePage getParent() {
        return this.parent;
    }

    public abstract String pageTitle();

    public void loadPage(String url) {
        BFLogger.logDebug((String)(this.getClass().getName() + ": Opening  page: " + url));
        BasePage.getDriver().get(url);
        BasePage.getDriver().waitForPageLoaded();
    }

    public boolean isUrlAndPageTitleAsCurrentPage(String url) {
        BasePage.getDriver().waitForPageLoaded();
        String pageTitle = this.pageTitle();
        String currentUrl = BasePage.getDriver().getCurrentUrl();
        String currentPageTitle = BasePage.getDriver().getTitle();
        if (!currentUrl.contains(url) || !pageTitle.equals(currentPageTitle)) {
            BFLogger.logDebug((String)(this.getClass().getName() + ": Current loaded page (" + url + ") with pageTitle (" + currentPageTitle + "). Page to load: (" + url + ") ,for page title: (" + pageTitle + ")"));
            return false;
        }
        return true;
    }

    public static boolean isElementDisplayed(By cssSelector) {
        List<WebElement> elements = BasePage.getDriver().findElements(cssSelector);
        if (elements.isEmpty()) {
            throw new BFElementNotFoundException(cssSelector);
        }
        return elements.get(0).isDisplayed();
    }

    public static boolean isElementDisplayed(By cssSelector, WebElement parent) {
        List elements = parent.findElements(cssSelector);
        if (elements.isEmpty()) {
            throw new BFElementNotFoundException(cssSelector);
        }
        return ((WebElement)elements.get(0)).isDisplayed();
    }

    public static boolean isElementDisplayed(By cssSelector, String text) {
        List<WebElement> elements = BasePage.getDriver().findElements(cssSelector);
        if (elements.isEmpty()) {
            throw new BFElementNotFoundException(cssSelector);
        }
        boolean retValue = elements.get(0).isDisplayed();
        if (retValue && text != null) {
            retValue = elements.get(0).getText().equals(text);
        }
        return retValue;
    }

    public static boolean isElementDisplayedNoException(By selector, WebElement parent) {
        try {
            return BasePage.isElementDisplayed(selector, parent);
        }
        catch (BFElementNotFoundException exc) {
            return false;
        }
    }

    public static boolean isElementDisplayedNoException(By selector) {
        try {
            return BasePage.isElementDisplayed(selector);
        }
        catch (BFElementNotFoundException exc) {
            return false;
        }
    }

    public static boolean isElementPresent(By cssSelector) {
        return !BasePage.getDriver().findElements(cssSelector).isEmpty();
    }

    public static boolean isLinkClickable(By selector) {
        WebElement linkElement = BasePage.getDriver().findElement(selector);
        return BasePage.isLinkClickable(linkElement);
    }

    public static boolean isLinkClickable(WebElement element) {
        return !element.getAttribute("href").equals("");
    }

    public static WebDriverWait getWebDriverWait() {
        if (Objects.isNull(driverManager)) {
            driverManager = new DriverManager(PROPERTIES_SELENIUM);
        }
        return driverManager.getDriverWait();
    }

    private static boolean isTitleElementDisplayed(By selector, String title) {
        boolean resValue;
        List<WebElement> pageTitle = BasePage.getDriver().findElements(selector);
        boolean bl = resValue = !pageTitle.isEmpty();
        if (resValue) {
            resValue = pageTitle.get(0).isDisplayed() && pageTitle.get(0).getText().equals(title);
        }
        return resValue;
    }

    public static void openInNewTab(String url) {
        JavascriptExecutor js = (JavascriptExecutor)BasePage.getDriver();
        js.executeScript("window.open(arguments[0], '_blank');", new Object[]{url});
        WindowUtils.switchWindow(url, true);
    }

    private static PropertiesSelenium setPropertiesSettings() {
        return (PropertiesSelenium)Guice.createInjector((Module[])new Module[]{PropertiesSettingsModule.init()}).getInstance(PropertiesSelenium.class);
    }

    private static void setRuntimeParametersSelenium() {
        BFLogger.logDebug((String)Arrays.asList(RuntimeParametersSelenium.values()).toString());
    }

    private static void setEnvironmentInstance() {
    }

    static {
        ANALYTICS = BaseTest.getAnalytics();
        PROPERTIES_SELENIUM = BasePage.setPropertiesSettings();
        BasePage.setRuntimeParametersSelenium();
        BasePage.setEnvironmentInstance();
    }
}

