/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.resourceserver;

import com.c4_soft.springaddons.security.oidc.starter.reactive.resourceserver.SpringAddonsReactiveJwtDecoderFactory;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ResponseStatus;

public class DefaultSpringAddonsReactiveJwtDecoderFactory
implements SpringAddonsReactiveJwtDecoderFactory {
    @Override
    public ReactiveJwtDecoder create(Optional<URI> jwkSetUri, Optional<URI> issuer, Optional<String> audience) {
        NimbusReactiveJwtDecoder decoder = jwkSetUri.isPresent() ? NimbusReactiveJwtDecoder.withJwkSetUri((String)jwkSetUri.get().toString()).build() : NimbusReactiveJwtDecoder.withIssuerLocation((String)issuer.orElseThrow(() -> new InvalidReactiveJwtDecoderCreationParametersException()).toString()).build();
        OAuth2TokenValidator defaultValidator = issuer.map(URI::toString).map(JwtValidators::createDefaultWithIssuer).orElse(JwtValidators.createDefault());
        OAuth2TokenValidator jwtValidator = audience.filter(StringUtils::hasText).map(opAudience -> new JwtClaimValidator("aud", aud -> aud != null && aud.contains(opAudience))).map(audValidator -> new DelegatingOAuth2TokenValidator(List.of(defaultValidator, audValidator))).orElse(defaultValidator);
        decoder.setJwtValidator(jwtValidator);
        return decoder;
    }

    @Generated
    public DefaultSpringAddonsReactiveJwtDecoderFactory() {
    }

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    static class InvalidReactiveJwtDecoderCreationParametersException
    extends RuntimeException {
        private static final long serialVersionUID = 3575615882241560832L;

        public InvalidReactiveJwtDecoderCreationParametersException() {
            super("At least one of jwkSetUri or issuer must be provided");
        }
    }
}

