/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive.client;

import com.c4_soft.springaddons.security.oidc.starter.properties.condition.configuration.IsClientMultiTenancyEnabled;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.configuration.IsClientWithLoginCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.configuration.IsNotServlet;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.ReactiveMultiTenantOAuth2PrincipalSupport;
import java.util.stream.Stream;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.PropertySource;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Conditional(value={IsClientWithLoginCondition.class, IsNotServlet.class, IsClientMultiTenancyEnabled.class})
@AutoConfiguration
@PropertySource(value={"classpath:/c4-spring-addons.properties"}, ignoreResourceNotFound=true)
public class ReactiveSpringAddonsAop {

    @Aspect
    @Component
    public static class ReactiveAuthorizedClientAspect {
        private final ServerOAuth2AuthorizedClientRepository authorizedClientRepo;

        @Pointcut(value="within(org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository+) && execution(* *.loadAuthorizedClient(..))")
        public void loadAuthorizedClient() {
        }

        @Pointcut(value="within(org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository+) && execution(* *.saveAuthorizedClient(..))")
        public void saveAuthorizedClient() {
        }

        @Pointcut(value="within(org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository+) && execution(* *.removeAuthorizedClient(..))")
        public void removeAuthorizedClient() {
        }

        @Pointcut(value="within(org.springframework.security.web.server.authentication.logout.ServerLogoutHandler+) && execution(* *.logout(..))")
        public void logout() {
        }

        @Around(value="loadAuthorizedClient()")
        public <T extends OAuth2AuthorizedClient> Mono<T> aroundLoadAuthorizedClient(ProceedingJoinPoint jp) throws Throwable {
            String clientRegistrationId = (String)jp.getArgs()[0];
            Authentication principal = (Authentication)jp.getArgs()[1];
            ServerWebExchange exchange = (ServerWebExchange)jp.getArgs()[2];
            Object[] args = Stream.of(jp.getArgs()).toArray(Object[]::new);
            return exchange.getSession().flatMap(session -> {
                args[1] = ReactiveMultiTenantOAuth2PrincipalSupport.getAuthentication(session, clientRegistrationId).orElse(principal);
                try {
                    return (Mono)jp.proceed(args);
                }
                catch (Throwable e) {
                    return Mono.error((Throwable)e);
                }
            });
        }

        @AfterReturning(value="saveAuthorizedClient()")
        public void afterSaveAuthorizedClient(JoinPoint jp) {
            OAuth2AuthorizedClient authorizedClient = (OAuth2AuthorizedClient)jp.getArgs()[0];
            Authentication principal = (Authentication)jp.getArgs()[1];
            ServerWebExchange exchange = (ServerWebExchange)jp.getArgs()[2];
            exchange.getSession().subscribe(session -> {
                String registrationId = authorizedClient.getClientRegistration().getRegistrationId();
                ReactiveMultiTenantOAuth2PrincipalSupport.add(session, registrationId, principal);
            });
        }

        @Around(value="removeAuthorizedClient()")
        public Mono<Void> aroundRemoveAuthorizedClient(ProceedingJoinPoint jp) {
            Object[] args = Stream.of(jp.getArgs()).toArray(Object[]::new);
            String clientRegistrationId = (String)args[0];
            Authentication principal = (Authentication)args[1];
            ServerWebExchange exchange = (ServerWebExchange)args[2];
            return exchange.getSession().flatMap(session -> {
                args[1] = ReactiveMultiTenantOAuth2PrincipalSupport.getAuthentication(session, clientRegistrationId).orElse(principal);
                try {
                    return (Mono)jp.proceed(args);
                }
                catch (Throwable e) {
                    return Mono.error((Throwable)e);
                }
            });
        }

        @Before(value="logout()")
        public void beforeServerLogoutHandlerLogout(JoinPoint jp) {
            A[] args = Stream.of(jp.getArgs()).toArray(Object[]::new);
            WebFilterExchange exchange = (WebFilterExchange)args[0];
            exchange.getExchange().getSession().subscribe(session -> ReactiveMultiTenantOAuth2PrincipalSupport.getAuthenticationsByClientRegistrationId(session).entrySet().forEach(e -> this.authorizedClientRepo.removeAuthorizedClient((String)e.getKey(), (Authentication)e.getValue(), exchange.getExchange()).subscribe()));
        }

        @Generated
        public ReactiveAuthorizedClientAspect(ServerOAuth2AuthorizedClientRepository authorizedClientRepo) {
            this.authorizedClientRepo = authorizedClientRepo;
        }
    }
}

