/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.properties.condition;

import lombok.Generated;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class HasPropertyPrefixCondition
implements Condition {
    private final String prefix;

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment environment = context.getEnvironment();
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            for (PropertySource propertySource : env.getPropertySources()) {
                if (!(propertySource instanceof EnumerablePropertySource)) continue;
                EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
                for (String key : enumerablePropertySource.getPropertyNames()) {
                    if (!key.startsWith(this.prefix)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Generated
    public HasPropertyPrefixCondition(String prefix) {
        this.prefix = prefix;
    }
}

