/*
 * Decompiled with CFR 0.152.
 */
package com.byteowls.vaadin.chartjs.options.elements;

import com.byteowls.vaadin.chartjs.options.FillMode;
import com.byteowls.vaadin.chartjs.options.elements.Element;
import com.byteowls.vaadin.chartjs.utils.And;
import com.byteowls.vaadin.chartjs.utils.JUtils;
import com.byteowls.vaadin.chartjs.utils.JsonBuilder;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class Line<T>
extends And<Element<T>>
implements JsonBuilder,
Serializable {
    private static final long serialVersionUID = 7489460081517158968L;
    private Double tension;
    private String backgroundColor;
    private Integer borderWidth;
    private String borderColor;
    private CapStyle borderCapStyle;
    private List<Integer> borderDash;
    private Double borderDashOffset;
    private JoinStyle borderJoinStyle;
    private Boolean capBezierPoints;
    private Boolean fill;
    private FillMode fillMode;

    public Line(Element<T> parent) {
        super(parent);
    }

    public Line<T> tension(double tension) {
        this.tension = tension;
        return this;
    }

    public Line<T> backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public Line<T> borderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public Line<T> borderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public Line<T> borderCapStyle(CapStyle borderCapStyle) {
        this.borderCapStyle = borderCapStyle;
        return this;
    }

    public Line<T> borderDash(Integer ... borderDash) {
        this.borderDash = Arrays.asList(borderDash);
        return this;
    }

    public Line<T> borderDashOffset(double borderDashOffset) {
        this.borderDashOffset = borderDashOffset;
        return this;
    }

    public Line<T> borderJoinStyle(JoinStyle borderJoinStyle) {
        this.borderJoinStyle = borderJoinStyle;
        return this;
    }

    public Line<T> capBezierPoints(boolean capBezierPoints) {
        this.capBezierPoints = capBezierPoints;
        return this;
    }

    public Line<T> fill(boolean fill) {
        this.fill = fill;
        return this;
    }

    public Line<T> fill(FillMode fillMode) {
        this.fillMode = fillMode;
        return this;
    }

    @Override
    public JsonObject buildJson() {
        JsonObject map = Json.createObject();
        JUtils.putNotNull(map, "tension", this.tension);
        JUtils.putNotNull(map, "backgroundColor", this.backgroundColor);
        JUtils.putNotNull(map, "borderColor", this.borderColor);
        JUtils.putNotNull(map, "borderWidth", this.borderWidth);
        if (this.borderCapStyle != null) {
            JUtils.putNotNull(map, "borderCapStyle", this.borderCapStyle.name().toLowerCase());
        }
        JUtils.putNotNullIntList(map, "borderDash", this.borderDash);
        JUtils.putNotNull(map, "borderDashOffset", this.borderDashOffset);
        if (this.borderJoinStyle != null) {
            JUtils.putNotNull(map, "borderJoinStyle", this.borderJoinStyle.name().toLowerCase());
        }
        JUtils.putNotNull(map, "capBezierPoints", this.capBezierPoints);
        if (this.fillMode == null) {
            JUtils.putNotNull(map, "fill", this.fill);
        } else {
            JUtils.putNotNull(map, "fill", this.fillMode.name().toLowerCase());
        }
        return map;
    }

    public static enum JoinStyle {
        BEVEL,
        ROUND,
        MITER;

    }

    public static enum CapStyle {
        BUTT,
        ROUND,
        SQUARE;

    }
}

