/*
 * Decompiled with CFR 0.152.
 */
package com.byteowls.vaadin.chartjs;

import com.byteowls.vaadin.chartjs.ChartJsState;
import com.byteowls.vaadin.chartjs.config.ChartConfig;
import com.vaadin.annotations.JavaScript;
import com.vaadin.annotations.StyleSheet;
import com.vaadin.ui.AbstractJavaScriptComponent;
import com.vaadin.ui.JavaScriptFunction;
import elemental.json.JsonArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@JavaScript(value={"vaadin://chartjs/Moment.js", "vaadin://chartjs/Chart.min.js", "vaadin://chartjs/hammer.min.js", "vaadin://chartjs/chartjs-plugin-zoom.min.js", "vaadin://chartjs/chartjs-plugin-annotation.min.js", "vaadin://chartjs/chartjs-connector.js"})
@StyleSheet(value={"vaadin://chartjs/chartjs-connector.css"})
public class ChartJs
extends AbstractJavaScriptComponent {
    private static final long serialVersionUID = 2999562112373836140L;
    private static final AtomicInteger nextMenuId = new AtomicInteger(0);
    private List<DataPointClickListener> dataPointClickListeners = new ArrayList<DataPointClickListener>();
    private List<LegendClickListener> legendClickListeners = new ArrayList<LegendClickListener>();
    private ChartConfig chartConfig;

    public ChartJs() {
        this.addStyleName("v-chartjs");
        this.addJsFunctions();
    }

    public ChartJs(ChartConfig chartConfig) {
        this();
        this.configure(chartConfig);
    }

    public void configure(ChartConfig chartConfig) {
        if (chartConfig != null) {
            this.chartConfig = chartConfig;
        }
    }

    public void attach() {
        if (this.chartConfig != null) {
            this.getState().configurationJson = this.chartConfig.buildJson();
        }
        super.attach();
    }

    public ChartConfig getConfig() {
        return this.chartConfig;
    }

    public void update() {
        if (this.chartConfig != null) {
            this.getState().configurationJson = this.chartConfig.buildJson();
        }
    }

    public void destroy() {
        this.callFunction("destroyChart", new Object[0]);
    }

    @Deprecated
    public void refreshData() {
        this.update();
    }

    public boolean isJsLoggingEnabled() {
        return this.getState().loggingEnabled;
    }

    public void setJsLoggingEnabled(boolean jsLoggingEnabled) {
        this.getState().loggingEnabled = jsLoggingEnabled;
    }

    public void addClickListener(DataPointClickListener listener) {
        this.dataPointClickListeners.add(listener);
        this.checkListenerState();
    }

    public void removeClickListener(DataPointClickListener listener) {
        this.dataPointClickListeners.remove(listener);
        this.checkListenerState();
    }

    public void addLegendClickListener(LegendClickListener listener) {
        this.legendClickListeners.add(listener);
        this.checkListenerState();
    }

    public void removeLegendClickListener(LegendClickListener listener) {
        this.legendClickListeners.remove(listener);
        this.checkListenerState();
    }

    private void checkListenerState() {
        this.getState().dataPointClickListenerFound = !this.dataPointClickListeners.isEmpty();
        this.getState().legendClickListenerFound = !this.legendClickListeners.isEmpty();
    }

    private void addJsFunctions() {
        this.addFunction("onDataPointClick", new JavaScriptFunction(){
            private static final long serialVersionUID = -6280339244713509848L;

            public void call(JsonArray arguments) {
                int datasetIndex = (int)arguments.getNumber(0);
                int dataIndex = (int)arguments.getNumber(1);
                for (DataPointClickListener l : ChartJs.this.dataPointClickListeners) {
                    l.onDataPointClick(datasetIndex, dataIndex);
                }
            }
        });
        this.addFunction("onLegendClick", new JavaScriptFunction(){
            private static final long serialVersionUID = 2949833327369862993L;

            public void call(JsonArray arguments) {
                int datasetIndex = (int)arguments.getNumber(0);
                boolean visible = arguments.getBoolean(1);
                JsonArray visblesJson = arguments.getArray(2);
                int[] visibles = new int[visblesJson.length()];
                for (int i = 0; i < visblesJson.length(); ++i) {
                    visibles[i] = (int)visblesJson.getNumber(i);
                }
                for (LegendClickListener l : ChartJs.this.legendClickListeners) {
                    l.onLegendClick(datasetIndex, visible, visibles);
                }
            }
        });
    }

    protected ChartJsState getState() {
        return (ChartJsState)super.getState();
    }

    public void setShowDownloadAction(boolean showDownloadAction) {
        this.getState().showDownloadAction = showDownloadAction;
    }

    public void setDownloadActionText(String downloadActionText) {
        this.getState().downloadActionText = downloadActionText;
    }

    public void setDownloadActionFilename(String downloadActionFilename) {
        this.getState().downloadActionFilename = downloadActionFilename;
    }

    public void setDownloadSetWhiteBackground(boolean downloadSetWhiteBackground) {
        this.getState().downloadSetWhiteBackground = downloadSetWhiteBackground;
    }

    public void addMenuEntry(String menuTitle, final Runnable action) {
        if (menuTitle == null || menuTitle.length() == 0) {
            throw new IllegalArgumentException("menuTitle missing");
        }
        if (action == null) {
            throw new IllegalArgumentException("action missing");
        }
        String callbackId = "ChartJsMenuItem" + nextMenuId.incrementAndGet();
        ChartJsState state = this.getState();
        if (state.menuItems == null) {
            state.menuItems = new HashMap<String, String>();
        }
        state.menuItems.put(callbackId, menuTitle);
        this.addFunction(callbackId, new JavaScriptFunction(){

            public void call(JsonArray arguments) {
                action.run();
            }
        });
    }

    public static interface LegendClickListener {
        public void onLegendClick(int var1, boolean var2, int[] var3);
    }

    public static interface DataPointClickListener {
        public void onDataPointClick(int var1, int var2);
    }
}

