package com.byteowls.vaadin.chartjs.options.scale;

import com.byteowls.vaadin.chartjs.utils.JUtils;

import elemental.json.JsonObject;

/**
 * The radial linear scale is used specifically for the radar and polar are chart types.
 * It overlays the chart area, rather than being positioned on one of the edges.
 *
 * @author michael@byteowls.com
 */
public class RadialLinearScale extends BaseScale<RadialLinearScale> {

    private static final long serialVersionUID = 2261466873004709837L;

    private Boolean reverse;

    private RadialAngleLine<RadialLinearScale> angleLines;
    private RadialPointLabel<RadialLinearScale> pointLabels;
    private RadialLinearTicks<RadialLinearScale> radialLinearTicks;

    public RadialLinearScale() {
        type(null);
    }

    /**
     *
     */
    public RadialLinearScale reverse(boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    /**
     * Used to configure angled lines that radiate from the center of the chart to the point labels. Note that these options only apply if display is true.
     */
    public RadialAngleLine<RadialLinearScale> angleLines() {
        if (this.angleLines == null) {
            this.angleLines = new RadialAngleLine<>(getThis());
        }
        return this.angleLines;
    }

    /**
     * Note that these options only apply if display is true.
     */
    public RadialPointLabel<RadialLinearScale> pointLabels() {
        if (this.pointLabels == null) {
            this.pointLabels = new RadialPointLabel<>(getThis());
        }
        return this.pointLabels;
    }

    /**
     * It defines options for the tick marks that are generated by the axis.
     */
    @Override
    public RadialLinearTicks<RadialLinearScale> ticks() {
        if (this.radialLinearTicks == null) {
            this.radialLinearTicks = new RadialLinearTicks<>(getThis());
        }
        return this.radialLinearTicks;
    }

    @Override
    public RadialLinearScale getThis() {
        return this;
    }

    @Override
    public JsonObject buildJson() {
        JsonObject map = super.buildJson();
        JUtils.putNotNull(map, "reverse", reverse);
        JUtils.putNotNull(map, "angleLines", angleLines);
        JUtils.putNotNull(map, "pointLabels", pointLabels);
        JUtils.putNotNull(map, "ticks", radialLinearTicks);
        return map;
    }
}
