/*
 * Decompiled with CFR 0.152.
 */
package com.byteowls.gradle;

import com.byteowls.gradle.tasks.file.DecryptPropertiesFileTask;
import com.byteowls.gradle.tasks.file.EncryptPropertiesFileTask;
import com.byteowls.gradle.tasks.text.DecryptTextTask;
import com.byteowls.gradle.tasks.text.EncryptTextTask;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.util.GradleVersion;

public class JasyptPlugin
implements Plugin<Project> {
    private static final String MIN_GRADLE_VERSION = "4.10";

    public void apply(Project project) {
        this.verifyGradleVersion();
        project.getTasks().create("encryptProperties", EncryptPropertiesFileTask.class);
        project.getTasks().create("decryptProperties", DecryptPropertiesFileTask.class);
        project.getTasks().create("encryptText", EncryptTextTask.class);
        project.getTasks().create("decryptText", DecryptTextTask.class);
    }

    private void verifyGradleVersion() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)MIN_GRADLE_VERSION)) < 0) {
            throw new GradleException("Jasypt plugin requires Gradle 4.10 or later. The current version is " + GradleVersion.current());
        }
    }
}

