/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import androidx.annotation.Nullable;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.JSIModuleType;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactSoftException;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.common.ViewUtil;

public class UIManagerHelper {
    @Nullable
    public static UIManager getUIManagerForReactTag(ReactContext context, int reactTag) {
        return UIManagerHelper.getUIManager(context, ViewUtil.getUIManagerType(reactTag));
    }

    @Nullable
    public static UIManager getUIManager(ReactContext context, int uiManagerType) {
        if (!context.hasActiveCatalystInstance()) {
            ReactSoftException.logSoftException("UIManagerHelper", new RuntimeException("Cannot get UIManager: no active Catalyst instance"));
            return null;
        }
        CatalystInstance catalystInstance = context.getCatalystInstance();
        return uiManagerType == 2 ? (UIManager)catalystInstance.getJSIModule(JSIModuleType.UIManager) : (UIManager)catalystInstance.getNativeModule(UIManagerModule.class);
    }
}

