/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting.mountitems;

import androidx.annotation.NonNull;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.mountitems.MountItem;

public class RemoveDeleteMultiMountItem
implements MountItem {
    @NonNull
    private int[] mMetadata;
    private static final int REMOVE_FLAG = 1;
    private static final int DELETE_FLAG = 2;
    private static final int INSTRUCTION_FIELDS_LEN = 4;
    private static final int TAG_INDEX = 0;
    private static final int PARENT_TAG_INDEX = 1;
    private static final int VIEW_INDEX_INDEX = 2;
    private static final int FLAGS_INDEX = 3;

    public RemoveDeleteMultiMountItem(@NonNull int[] metadata) {
        this.mMetadata = metadata;
    }

    @Override
    public void execute(@NonNull MountingManager mountingManager) {
        int flags;
        int i;
        for (i = 0; i < this.mMetadata.length; i += 4) {
            flags = this.mMetadata[i + 3];
            if ((flags & 1) == 0) continue;
            int parentTag = this.mMetadata[i + 1];
            int index = this.mMetadata[i + 2];
            mountingManager.removeViewAt(parentTag, index);
        }
        for (i = 0; i < this.mMetadata.length; i += 4) {
            flags = this.mMetadata[i + 3];
            if ((flags & 2) == 0) continue;
            int tag = this.mMetadata[i + 0];
            mountingManager.deleteView(tag);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.mMetadata.length; i += 4) {
            if (s.length() > 0) {
                s.append("\n");
            }
            s.append("RemoveDeleteMultiMountItem (").append(i / 4 + 1).append("/").append(this.mMetadata.length / 4).append("): [").append(this.mMetadata[i + 0]).append("] parent [").append(this.mMetadata[i + 1]).append("] idx ").append(this.mMetadata[i + 2]).append(" ").append(this.mMetadata[i + 3]);
        }
        return s.toString();
    }
}

