/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.os.Build;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.res.ResourcesCompat;
import java.util.HashMap;
import java.util.Map;

public class ReactFontManager {
    private static final String[] EXTENSIONS = new String[]{"", "_bold", "_italic", "_bold_italic"};
    private static final String[] FILE_EXTENSIONS = new String[]{".ttf", ".otf"};
    private static final String FONTS_ASSET_PATH = "fonts/";
    private static ReactFontManager sReactFontManagerInstance;
    private final Map<String, FontFamily> mFontCache = new HashMap<String, FontFamily>();
    private final Map<String, Typeface> mCustomTypefaceCache = new HashMap<String, Typeface>();

    private ReactFontManager() {
    }

    public static ReactFontManager getInstance() {
        if (sReactFontManagerInstance == null) {
            sReactFontManagerInstance = new ReactFontManager();
        }
        return sReactFontManagerInstance;
    }

    @Nullable
    public Typeface getTypeface(String fontFamilyName, int style2, AssetManager assetManager) {
        return this.getTypeface(fontFamilyName, style2, 0, assetManager);
    }

    @Nullable
    public Typeface getTypeface(String fontFamilyName, int style2, int weight, AssetManager assetManager) {
        Typeface typeface;
        if (this.mCustomTypefaceCache.containsKey(fontFamilyName)) {
            Typeface typeface2 = this.mCustomTypefaceCache.get(fontFamilyName);
            if (Build.VERSION.SDK_INT >= 28 && weight >= 100 && weight <= 1000) {
                return Typeface.create((Typeface)typeface2, (int)weight, ((style2 & 2) != 0 ? 1 : 0) != 0);
            }
            return Typeface.create((Typeface)typeface2, (int)style2);
        }
        FontFamily fontFamily = this.mFontCache.get(fontFamilyName);
        if (fontFamily == null) {
            fontFamily = new FontFamily();
            this.mFontCache.put(fontFamilyName, fontFamily);
        }
        if ((typeface = fontFamily.getTypeface(style2)) == null && (typeface = ReactFontManager.createTypeface(fontFamilyName, style2, assetManager)) != null) {
            fontFamily.setTypeface(style2, typeface);
        }
        return typeface;
    }

    public void addCustomFont(@NonNull Context context, @NonNull String fontFamily, int fontId) {
        Typeface font = ResourcesCompat.getFont((Context)context, (int)fontId);
        if (font != null) {
            this.mCustomTypefaceCache.put(fontFamily, font);
        }
    }

    public void setTypeface(String fontFamilyName, int style2, Typeface typeface) {
        if (typeface != null) {
            FontFamily fontFamily = this.mFontCache.get(fontFamilyName);
            if (fontFamily == null) {
                fontFamily = new FontFamily();
                this.mFontCache.put(fontFamilyName, fontFamily);
            }
            fontFamily.setTypeface(style2, typeface);
        }
    }

    @Nullable
    private static Typeface createTypeface(String fontFamilyName, int style2, AssetManager assetManager) {
        String extension = EXTENSIONS[style2];
        for (String fileExtension : FILE_EXTENSIONS) {
            String fileName = FONTS_ASSET_PATH + fontFamilyName + extension + fileExtension;
            try {
                return Typeface.createFromAsset((AssetManager)assetManager, (String)fileName);
            }
            catch (RuntimeException runtimeException) {
            }
        }
        return Typeface.create((String)fontFamilyName, (int)style2);
    }

    private static class FontFamily {
        private SparseArray<Typeface> mTypefaceSparseArray = new SparseArray(4);

        private FontFamily() {
        }

        public Typeface getTypeface(int style2) {
            return (Typeface)this.mTypefaceSparseArray.get(style2);
        }

        public void setTypeface(int style2, Typeface typeface) {
            this.mTypefaceSparseArray.put(style2, (Object)typeface);
        }
    }
}

