/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.picker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.picker.ReactPicker;
import com.facebook.react.views.picker.ReactPickerItem;
import com.facebook.react.views.picker.events.PickerItemSelectEvent;
import java.util.List;

public abstract class ReactPickerManager
extends SimpleViewManager<ReactPicker> {
    @ReactProp(name="items")
    public void setItems(ReactPicker view, @Nullable ReadableArray items) {
        List<ReactPickerItem> pickerItems = ReactPickerItem.createFromJsArrayMap(items);
        view.setStagedItems(pickerItems);
    }

    @ReactProp(name="color", customType="Color")
    public void setColor(ReactPicker view, @Nullable Integer color) {
        view.setStagedPrimaryTextColor(color);
    }

    @ReactProp(name="prompt")
    public void setPrompt(ReactPicker view, @Nullable String prompt) {
        view.setPrompt(prompt);
    }

    @ReactProp(name="enabled", defaultBoolean=true)
    public void setEnabled(ReactPicker view, boolean enabled) {
        view.setEnabled(enabled);
    }

    @ReactProp(name="selected")
    public void setSelected(ReactPicker view, int selected) {
        view.setStagedSelection(selected);
    }

    @Override
    protected void onAfterUpdateTransaction(ReactPicker view) {
        super.onAfterUpdateTransaction(view);
        view.commitStagedData();
    }

    @Override
    protected void addEventEmitters(ThemedReactContext reactContext, ReactPicker picker) {
        picker.setOnSelectListener(new PickerEventEmitter(picker, reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher()));
    }

    @Override
    public void receiveCommand(@NonNull ReactPicker view, String commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case "setNativeSelectedPosition": {
                if (args == null) break;
                view.setImmediateSelection(args.getInt(0));
            }
        }
    }

    private static class PickerEventEmitter
    implements ReactPicker.OnSelectListener {
        private final ReactPicker mReactPicker;
        private final EventDispatcher mEventDispatcher;

        public PickerEventEmitter(ReactPicker reactPicker, EventDispatcher eventDispatcher) {
            this.mReactPicker = reactPicker;
            this.mEventDispatcher = eventDispatcher;
        }

        @Override
        public void onItemSelected(int position) {
            this.mEventDispatcher.dispatchEvent(new PickerItemSelectEvent(this.mReactPicker.getId(), position));
        }
    }
}

