/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.art;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import android.graphics.Shader;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.art.ARTVirtualNode;
import com.facebook.react.views.art.PropHelper;

public class ARTShapeShadowNode
extends ARTVirtualNode {
    private static final int CAP_BUTT = 0;
    private static final int CAP_ROUND = 1;
    private static final int CAP_SQUARE = 2;
    private static final int JOIN_BEVEL = 2;
    private static final int JOIN_MITER = 0;
    private static final int JOIN_ROUND = 1;
    private static final int PATH_TYPE_ARC = 4;
    private static final int PATH_TYPE_CLOSE = 1;
    private static final int PATH_TYPE_CURVETO = 3;
    private static final int PATH_TYPE_LINETO = 2;
    private static final int PATH_TYPE_MOVETO = 0;
    private static final int COLOR_TYPE_SOLID_COLOR = 0;
    private static final int COLOR_TYPE_LINEAR_GRADIENT = 1;
    private static final int COLOR_TYPE_RADIAL_GRADIENT = 2;
    private static final int COLOR_TYPE_PATTERN = 3;
    @Nullable
    protected Path mPath;
    @Nullable
    private float[] mStrokeColor;
    @Nullable
    private float[] mBrushData;
    @Nullable
    private float[] mStrokeDash;
    private float mStrokeWidth = 1.0f;
    private int mStrokeCap = 1;
    private int mStrokeJoin = 1;

    @ReactProp(name="d")
    public void setShapePath(@Nullable ReadableArray shapePath) {
        float[] pathData = PropHelper.toFloatArray(shapePath);
        this.mPath = this.createPath(pathData);
        this.markUpdated();
    }

    @ReactProp(name="stroke")
    public void setStroke(@Nullable ReadableArray strokeColors) {
        this.mStrokeColor = PropHelper.toFloatArray(strokeColors);
        this.markUpdated();
    }

    @ReactProp(name="strokeDash")
    public void setStrokeDash(@Nullable ReadableArray strokeDash) {
        this.mStrokeDash = PropHelper.toFloatArray(strokeDash);
        this.markUpdated();
    }

    @ReactProp(name="fill")
    public void setFill(@Nullable ReadableArray fillColors) {
        this.mBrushData = PropHelper.toFloatArray(fillColors);
        this.markUpdated();
    }

    @ReactProp(name="strokeWidth", defaultFloat=1.0f)
    public void setStrokeWidth(float strokeWidth) {
        this.mStrokeWidth = strokeWidth;
        this.markUpdated();
    }

    @ReactProp(name="strokeCap", defaultInt=1)
    public void setStrokeCap(int strokeCap) {
        this.mStrokeCap = strokeCap;
        this.markUpdated();
    }

    @ReactProp(name="strokeJoin", defaultInt=1)
    public void setStrokeJoin(int strokeJoin) {
        this.mStrokeJoin = strokeJoin;
        this.markUpdated();
    }

    @Override
    public void draw(Canvas canvas, Paint paint, float opacity) {
        if ((opacity *= this.mOpacity) > 0.01f) {
            this.saveAndSetupCanvas(canvas);
            if (this.mPath == null) {
                throw new JSApplicationIllegalArgumentException("Shapes should have a valid path (d) prop");
            }
            if (this.setupFillPaint(paint, opacity)) {
                canvas.drawPath(this.mPath, paint);
            }
            if (this.setupStrokePaint(paint, opacity)) {
                canvas.drawPath(this.mPath, paint);
            }
            this.restoreCanvas(canvas);
        }
        this.markUpdateSeen();
    }

    protected boolean setupStrokePaint(Paint paint, float opacity) {
        if (this.mStrokeWidth == 0.0f || this.mStrokeColor == null || this.mStrokeColor.length == 0) {
            return false;
        }
        paint.reset();
        paint.setFlags(1);
        paint.setStyle(Paint.Style.STROKE);
        switch (this.mStrokeCap) {
            case 0: {
                paint.setStrokeCap(Paint.Cap.BUTT);
                break;
            }
            case 2: {
                paint.setStrokeCap(Paint.Cap.SQUARE);
                break;
            }
            case 1: {
                paint.setStrokeCap(Paint.Cap.ROUND);
                break;
            }
            default: {
                throw new JSApplicationIllegalArgumentException("strokeCap " + this.mStrokeCap + " unrecognized");
            }
        }
        switch (this.mStrokeJoin) {
            case 0: {
                paint.setStrokeJoin(Paint.Join.MITER);
                break;
            }
            case 2: {
                paint.setStrokeJoin(Paint.Join.BEVEL);
                break;
            }
            case 1: {
                paint.setStrokeJoin(Paint.Join.ROUND);
                break;
            }
            default: {
                throw new JSApplicationIllegalArgumentException("strokeJoin " + this.mStrokeJoin + " unrecognized");
            }
        }
        paint.setStrokeWidth(this.mStrokeWidth * this.mScale);
        paint.setARGB((int)(this.mStrokeColor.length > 3 ? this.mStrokeColor[3] * opacity * 255.0f : opacity * 255.0f), (int)(this.mStrokeColor[0] * 255.0f), (int)(this.mStrokeColor[1] * 255.0f), (int)(this.mStrokeColor[2] * 255.0f));
        if (this.mStrokeDash != null && this.mStrokeDash.length > 0) {
            paint.setPathEffect((PathEffect)new DashPathEffect(this.mStrokeDash, 0.0f));
        }
        return true;
    }

    protected boolean setupFillPaint(Paint paint, float opacity) {
        if (this.mBrushData != null && this.mBrushData.length > 0) {
            paint.reset();
            paint.setFlags(1);
            paint.setStyle(Paint.Style.FILL);
            int colorType = (int)this.mBrushData[0];
            switch (colorType) {
                case 0: {
                    paint.setARGB((int)(this.mBrushData.length > 4 ? this.mBrushData[4] * opacity * 255.0f : opacity * 255.0f), (int)(this.mBrushData[1] * 255.0f), (int)(this.mBrushData[2] * 255.0f), (int)(this.mBrushData[3] * 255.0f));
                    break;
                }
                case 1: {
                    if (this.mBrushData.length < 5) {
                        FLog.w((String)"ReactNative", (String)("[ARTShapeShadowNode setupFillPaint] expects 5 elements, received " + this.mBrushData.length));
                        return false;
                    }
                    float gradientStartX = this.mBrushData[1] * this.mScale;
                    float gradientStartY = this.mBrushData[2] * this.mScale;
                    float gradientEndX = this.mBrushData[3] * this.mScale;
                    float gradientEndY = this.mBrushData[4] * this.mScale;
                    int stops = (this.mBrushData.length - 5) / 5;
                    int[] colors = null;
                    float[] positions = null;
                    if (stops > 0) {
                        colors = new int[stops];
                        positions = new float[stops];
                        for (int i = 0; i < stops; ++i) {
                            positions[i] = this.mBrushData[5 + 4 * stops + i];
                            int r = (int)(255.0f * this.mBrushData[5 + 4 * i + 0]);
                            int g = (int)(255.0f * this.mBrushData[5 + 4 * i + 1]);
                            int b = (int)(255.0f * this.mBrushData[5 + 4 * i + 2]);
                            int a = (int)(255.0f * this.mBrushData[5 + 4 * i + 3]);
                            colors[i] = Color.argb((int)a, (int)r, (int)g, (int)b);
                        }
                    }
                    paint.setShader((Shader)new LinearGradient(gradientStartX, gradientStartY, gradientEndX, gradientEndY, colors, positions, Shader.TileMode.CLAMP));
                    break;
                }
                default: {
                    FLog.w((String)"ReactNative", (String)("ART: Color type " + colorType + " not supported!"));
                }
            }
            return true;
        }
        return false;
    }

    private float modulus(float x, float y) {
        float remainder;
        float modulus = remainder = x % y;
        if (remainder < 0.0f) {
            modulus += y;
        }
        return modulus;
    }

    private Path createPath(float[] data) {
        Path path = new Path();
        path.moveTo(0.0f, 0.0f);
        int i = 0;
        block7: while (i < data.length) {
            int type = (int)data[i++];
            switch (type) {
                case 0: {
                    path.moveTo(data[i++] * this.mScale, data[i++] * this.mScale);
                    continue block7;
                }
                case 1: {
                    path.close();
                    continue block7;
                }
                case 2: {
                    path.lineTo(data[i++] * this.mScale, data[i++] * this.mScale);
                    continue block7;
                }
                case 3: {
                    path.cubicTo(data[i++] * this.mScale, data[i++] * this.mScale, data[i++] * this.mScale, data[i++] * this.mScale, data[i++] * this.mScale, data[i++] * this.mScale);
                    continue block7;
                }
                case 4: {
                    float x = data[i++] * this.mScale;
                    float y = data[i++] * this.mScale;
                    float r = data[i++] * this.mScale;
                    float start = (float)Math.toDegrees(data[i++]);
                    float end = (float)Math.toDegrees(data[i++]);
                    boolean counterClockwise = data[i++] != 1.0f;
                    float sweep = end - start;
                    if (Math.abs(sweep) >= 360.0f) {
                        path.addCircle(x, y, r, counterClockwise ? Path.Direction.CCW : Path.Direction.CW);
                        continue block7;
                    }
                    sweep = this.modulus(sweep, 360.0f);
                    if (counterClockwise && sweep < 360.0f) {
                        sweep = -1.0f * (360.0f - sweep);
                    }
                    RectF oval = new RectF(x - r, y - r, x + r, y + r);
                    path.arcTo(oval, start, sweep);
                    continue block7;
                }
            }
            throw new JSApplicationIllegalArgumentException("Unrecognized drawing instruction " + type);
        }
        return path;
    }
}

