/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.facebook.react.uimanager.ViewGroupManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ViewGroupDrawingOrderHelper {
    private final ViewGroup mViewGroup;
    private int mNumberOfChildrenWithZIndex = 0;
    @Nullable
    private int[] mDrawingOrderIndices;

    public ViewGroupDrawingOrderHelper(ViewGroup viewGroup) {
        this.mViewGroup = viewGroup;
    }

    public void handleAddView(View view) {
        if (ViewGroupManager.getViewZIndex(view) != null) {
            ++this.mNumberOfChildrenWithZIndex;
        }
        this.mDrawingOrderIndices = null;
    }

    public void handleRemoveView(View view) {
        if (ViewGroupManager.getViewZIndex(view) != null) {
            --this.mNumberOfChildrenWithZIndex;
        }
        this.mDrawingOrderIndices = null;
    }

    public boolean shouldEnableCustomDrawingOrder() {
        return this.mNumberOfChildrenWithZIndex > 0;
    }

    public int getChildDrawingOrder(int childCount, int index) {
        if (this.mDrawingOrderIndices == null) {
            int i;
            ArrayList<View> viewsToSort = new ArrayList<View>();
            for (i = 0; i < childCount; ++i) {
                viewsToSort.add(this.mViewGroup.getChildAt(i));
            }
            Collections.sort(viewsToSort, new Comparator<View>(){

                @Override
                public int compare(View view1, View view2) {
                    Integer view2ZIndex;
                    Integer view1ZIndex = ViewGroupManager.getViewZIndex(view1);
                    if (view1ZIndex == null) {
                        view1ZIndex = 0;
                    }
                    if ((view2ZIndex = ViewGroupManager.getViewZIndex(view2)) == null) {
                        view2ZIndex = 0;
                    }
                    return view1ZIndex - view2ZIndex;
                }
            });
            this.mDrawingOrderIndices = new int[childCount];
            for (i = 0; i < childCount; ++i) {
                View child = (View)viewsToSort.get(i);
                this.mDrawingOrderIndices[i] = this.mViewGroup.indexOfChild(child);
            }
        }
        return this.mDrawingOrderIndices[index];
    }

    public void update() {
        this.mNumberOfChildrenWithZIndex = 0;
        for (int i = 0; i < this.mViewGroup.getChildCount(); ++i) {
            if (ViewGroupManager.getViewZIndex(this.mViewGroup.getChildAt(i)) == null) continue;
            ++this.mNumberOfChildrenWithZIndex;
        }
        this.mDrawingOrderIndices = null;
    }
}

