/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.BaseViewManagerInterface;
import com.facebook.react.uimanager.ViewManagerDelegate;

public abstract class BaseViewManagerDelegate<T extends View, U extends BaseViewManagerInterface<T>>
implements ViewManagerDelegate<T> {
    protected final U mViewManager;

    public BaseViewManagerDelegate(U viewManager) {
        this.mViewManager = viewManager;
    }

    @Override
    public void setProperty(T view, String propName, @Nullable Object value) {
        switch (propName) {
            case "accessibilityActions": {
                this.mViewManager.setAccessibilityActions(view, (ReadableArray)value);
                break;
            }
            case "accessibilityHint": {
                this.mViewManager.setAccessibilityHint(view, (String)value);
                break;
            }
            case "accessibilityLabel": {
                this.mViewManager.setAccessibilityLabel(view, (String)value);
                break;
            }
            case "accessibilityLiveRegion": {
                this.mViewManager.setAccessibilityLiveRegion(view, (String)value);
                break;
            }
            case "accessibilityRole": {
                this.mViewManager.setAccessibilityRole(view, (String)value);
                break;
            }
            case "accessibilityState": {
                this.mViewManager.setViewState(view, (ReadableMap)value);
                break;
            }
            case "backgroundColor": {
                this.mViewManager.setBackgroundColor(view, value == null ? 0 : ((Double)value).intValue());
                break;
            }
            case "borderRadius": {
                this.mViewManager.setBorderRadius(view, value == null ? Float.NaN : ((Double)value).floatValue());
                break;
            }
            case "borderBottomLeftRadius": {
                this.mViewManager.setBorderBottomLeftRadius(view, value == null ? Float.NaN : ((Double)value).floatValue());
                break;
            }
            case "borderBottomRightRadius": {
                this.mViewManager.setBorderBottomRightRadius(view, value == null ? Float.NaN : ((Double)value).floatValue());
                break;
            }
            case "borderTopLeftRadius": {
                this.mViewManager.setBorderTopLeftRadius(view, value == null ? Float.NaN : ((Double)value).floatValue());
                break;
            }
            case "borderTopRightRadius": {
                this.mViewManager.setBorderTopRightRadius(view, value == null ? Float.NaN : ((Double)value).floatValue());
                break;
            }
            case "elevation": {
                this.mViewManager.setElevation(view, value == null ? 0.0f : ((Double)value).floatValue());
                break;
            }
            case "importantForAccessibility": {
                this.mViewManager.setImportantForAccessibility(view, (String)value);
                break;
            }
            case "nativeID": {
                this.mViewManager.setNativeId(view, (String)value);
                break;
            }
            case "opacity": {
                this.mViewManager.setOpacity(view, value == null ? 1.0f : ((Double)value).floatValue());
                break;
            }
            case "renderToHardwareTextureAndroid": {
                this.mViewManager.setRenderToHardwareTexture(view, value == null ? false : (Boolean)value);
                break;
            }
            case "rotation": {
                this.mViewManager.setRotation(view, value == null ? 0.0f : ((Double)value).floatValue());
                break;
            }
            case "scaleX": {
                this.mViewManager.setScaleX(view, value == null ? 1.0f : ((Double)value).floatValue());
                break;
            }
            case "scaleY": {
                this.mViewManager.setScaleY(view, value == null ? 1.0f : ((Double)value).floatValue());
                break;
            }
            case "testID": {
                this.mViewManager.setTestId(view, (String)value);
                break;
            }
            case "transform": {
                this.mViewManager.setTransform(view, (ReadableArray)value);
                break;
            }
            case "translateX": {
                this.mViewManager.setTranslateX(view, value == null ? 0.0f : ((Double)value).floatValue());
                break;
            }
            case "translateY": {
                this.mViewManager.setTranslateY(view, value == null ? 0.0f : ((Double)value).floatValue());
                break;
            }
            case "zIndex": {
                this.mViewManager.setZIndex(view, value == null ? 0.0f : ((Double)value).floatValue());
            }
        }
    }
}

