/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.BaseViewManagerInterface;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.MatrixMathHelper;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import com.facebook.react.uimanager.ReactZIndexedViewGroup;
import com.facebook.react.uimanager.TransformHelper;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.util.ReactFindViewUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseViewManager<T extends View, C extends LayoutShadowNode>
extends ViewManager<T, C>
implements BaseViewManagerInterface<T> {
    private static final int PERSPECTIVE_ARRAY_INVERTED_CAMERA_DISTANCE_INDEX = 2;
    private static final float CAMERA_DISTANCE_NORMALIZATION_MULTIPLIER = (float)Math.sqrt(5.0);
    private static MatrixMathHelper.MatrixDecompositionContext sMatrixDecompositionContext = new MatrixMathHelper.MatrixDecompositionContext();
    private static double[] sTransformDecompositionArray = new double[16];
    public static final Map<String, Integer> sStateDescription = new HashMap<String, Integer>();
    private static final String STATE_CHECKED = "checked";
    private static final String STATE_BUSY = "busy";
    private static final String STATE_EXPANDED = "expanded";
    private static final String STATE_MIXED = "mixed";

    @Override
    @ReactProp(name="backgroundColor", defaultInt=0, customType="Color")
    public void setBackgroundColor(@NonNull T view, int backgroundColor) {
        view.setBackgroundColor(backgroundColor);
    }

    @Override
    @ReactProp(name="transform")
    public void setTransform(@NonNull T view, @Nullable ReadableArray matrix) {
        if (matrix == null) {
            BaseViewManager.resetTransformProperty(view);
        } else {
            BaseViewManager.setTransformProperty(view, matrix);
        }
    }

    @Override
    @ReactProp(name="opacity", defaultFloat=1.0f)
    public void setOpacity(@NonNull T view, float opacity) {
        view.setAlpha(opacity);
    }

    @Override
    @ReactProp(name="elevation")
    public void setElevation(@NonNull T view, float elevation) {
        ViewCompat.setElevation(view, (float)PixelUtil.toPixelFromDIP(elevation));
    }

    @Override
    @ReactProp(name="zIndex")
    public void setZIndex(@NonNull T view, float zIndex) {
        int integerZIndex = Math.round(zIndex);
        ViewGroupManager.setViewZIndex(view, integerZIndex);
        ViewParent parent = view.getParent();
        if (parent instanceof ReactZIndexedViewGroup) {
            ((ReactZIndexedViewGroup)parent).updateDrawingOrder();
        }
    }

    @Override
    @ReactProp(name="renderToHardwareTextureAndroid")
    public void setRenderToHardwareTexture(@NonNull T view, boolean useHWTexture) {
        view.setLayerType(useHWTexture ? 2 : 0, null);
    }

    @Override
    @ReactProp(name="testID")
    public void setTestId(@NonNull T view, @Nullable String testId) {
        view.setTag(R.id.react_test_id, (Object)testId);
        view.setTag((Object)testId);
    }

    @Override
    @ReactProp(name="nativeID")
    public void setNativeId(@NonNull T view, @Nullable String nativeId) {
        view.setTag(R.id.view_tag_native_id, (Object)nativeId);
        ReactFindViewUtil.notifyViewRendered(view);
    }

    @Override
    @ReactProp(name="accessibilityLabel")
    public void setAccessibilityLabel(@NonNull T view, @Nullable String accessibilityLabel) {
        view.setTag(R.id.accessibility_label, (Object)accessibilityLabel);
        this.updateViewContentDescription(view);
    }

    @Override
    @ReactProp(name="accessibilityHint")
    public void setAccessibilityHint(@NonNull T view, @Nullable String accessibilityHint) {
        view.setTag(R.id.accessibility_hint, (Object)accessibilityHint);
        this.updateViewContentDescription(view);
    }

    @Override
    @ReactProp(name="accessibilityRole")
    public void setAccessibilityRole(@NonNull T view, @Nullable String accessibilityRole) {
        if (accessibilityRole == null) {
            return;
        }
        view.setTag(R.id.accessibility_role, (Object)ReactAccessibilityDelegate.AccessibilityRole.fromValue(accessibilityRole));
    }

    @Override
    @ReactProp(name="accessibilityState")
    public void setViewState(@NonNull T view, @Nullable ReadableMap accessibilityState) {
        if (accessibilityState == null) {
            return;
        }
        view.setTag(R.id.accessibility_state, (Object)accessibilityState);
        view.setSelected(false);
        view.setEnabled(true);
        ReadableMapKeySetIterator i = accessibilityState.keySetIterator();
        while (i.hasNextKey()) {
            String state = i.nextKey();
            if (state.equals(STATE_BUSY) || state.equals(STATE_EXPANDED) || state.equals(STATE_CHECKED) && accessibilityState.getType(STATE_CHECKED) == ReadableType.String) {
                this.updateViewContentDescription(view);
                break;
            }
            if (!view.isAccessibilityFocused()) continue;
            view.sendAccessibilityEvent(1);
        }
    }

    private void updateViewContentDescription(@NonNull T view) {
        Dynamic text;
        String accessibilityLabel = (String)view.getTag(R.id.accessibility_label);
        ReadableMap accessibilityState = (ReadableMap)view.getTag(R.id.accessibility_state);
        String accessibilityHint = (String)view.getTag(R.id.accessibility_hint);
        ArrayList<String> contentDescription = new ArrayList<String>();
        ReadableMap accessibilityValue = (ReadableMap)view.getTag(R.id.accessibility_value);
        if (accessibilityLabel != null) {
            contentDescription.add(accessibilityLabel);
        }
        if (accessibilityState != null) {
            ReadableMapKeySetIterator i = accessibilityState.keySetIterator();
            while (i.hasNextKey()) {
                String state = i.nextKey();
                Dynamic value = accessibilityState.getDynamic(state);
                if (state.equals(STATE_CHECKED) && value.getType() == ReadableType.String && value.asString().equals(STATE_MIXED)) {
                    contentDescription.add(view.getContext().getString(R.string.state_mixed_description));
                    continue;
                }
                if (state.equals(STATE_BUSY) && value.getType() == ReadableType.Boolean && value.asBoolean()) {
                    contentDescription.add(view.getContext().getString(R.string.state_busy_description));
                    continue;
                }
                if (!state.equals(STATE_EXPANDED) || value.getType() != ReadableType.Boolean) continue;
                contentDescription.add(view.getContext().getString(value.asBoolean() ? R.string.state_expanded_description : R.string.state_collapsed_description));
            }
        }
        if (accessibilityValue != null && accessibilityValue.hasKey("text") && (text = accessibilityValue.getDynamic("text")) != null && text.getType() == ReadableType.String) {
            contentDescription.add(text.asString());
        }
        if (accessibilityHint != null) {
            contentDescription.add(accessibilityHint);
        }
        if (contentDescription.size() > 0) {
            view.setContentDescription((CharSequence)TextUtils.join((CharSequence)", ", contentDescription));
        }
    }

    @Override
    @ReactProp(name="accessibilityActions")
    public void setAccessibilityActions(T view, ReadableArray accessibilityActions) {
        if (accessibilityActions == null) {
            return;
        }
        view.setTag(R.id.accessibility_actions, (Object)accessibilityActions);
    }

    @ReactProp(name="accessibilityValue")
    public void setAccessibilityValue(T view, ReadableMap accessibilityValue) {
        if (accessibilityValue == null) {
            return;
        }
        view.setTag(R.id.accessibility_value, (Object)accessibilityValue);
        if (accessibilityValue.hasKey("text")) {
            this.updateViewContentDescription(view);
        }
    }

    @Override
    @ReactProp(name="importantForAccessibility")
    public void setImportantForAccessibility(@NonNull T view, @Nullable String importantForAccessibility) {
        if (importantForAccessibility == null || importantForAccessibility.equals("auto")) {
            ViewCompat.setImportantForAccessibility(view, (int)0);
        } else if (importantForAccessibility.equals("yes")) {
            ViewCompat.setImportantForAccessibility(view, (int)1);
        } else if (importantForAccessibility.equals("no")) {
            ViewCompat.setImportantForAccessibility(view, (int)2);
        } else if (importantForAccessibility.equals("no-hide-descendants")) {
            ViewCompat.setImportantForAccessibility(view, (int)4);
        }
    }

    @Override
    @Deprecated
    @ReactProp(name="rotation")
    public void setRotation(@NonNull T view, float rotation) {
        view.setRotation(rotation);
    }

    @Override
    @Deprecated
    @ReactProp(name="scaleX", defaultFloat=1.0f)
    public void setScaleX(@NonNull T view, float scaleX) {
        view.setScaleX(scaleX);
    }

    @Override
    @Deprecated
    @ReactProp(name="scaleY", defaultFloat=1.0f)
    public void setScaleY(@NonNull T view, float scaleY) {
        view.setScaleY(scaleY);
    }

    @Override
    @Deprecated
    @ReactProp(name="translateX", defaultFloat=0.0f)
    public void setTranslateX(@NonNull T view, float translateX) {
        view.setTranslationX(PixelUtil.toPixelFromDIP(translateX));
    }

    @Override
    @Deprecated
    @ReactProp(name="translateY", defaultFloat=0.0f)
    public void setTranslateY(@NonNull T view, float translateY) {
        view.setTranslationY(PixelUtil.toPixelFromDIP(translateY));
    }

    @Override
    @ReactProp(name="accessibilityLiveRegion")
    public void setAccessibilityLiveRegion(@NonNull T view, @Nullable String liveRegion) {
        if (liveRegion == null || liveRegion.equals("none")) {
            ViewCompat.setAccessibilityLiveRegion(view, (int)0);
        } else if (liveRegion.equals("polite")) {
            ViewCompat.setAccessibilityLiveRegion(view, (int)1);
        } else if (liveRegion.equals("assertive")) {
            ViewCompat.setAccessibilityLiveRegion(view, (int)2);
        }
    }

    private static void setTransformProperty(@NonNull View view, ReadableArray transforms) {
        sMatrixDecompositionContext.reset();
        TransformHelper.processTransform(transforms, sTransformDecompositionArray);
        MatrixMathHelper.decomposeMatrix(sTransformDecompositionArray, sMatrixDecompositionContext);
        view.setTranslationX(PixelUtil.toPixelFromDIP(BaseViewManager.sanitizeFloatPropertyValue((float)BaseViewManager.sMatrixDecompositionContext.translation[0])));
        view.setTranslationY(PixelUtil.toPixelFromDIP(BaseViewManager.sanitizeFloatPropertyValue((float)BaseViewManager.sMatrixDecompositionContext.translation[1])));
        view.setRotation(BaseViewManager.sanitizeFloatPropertyValue((float)BaseViewManager.sMatrixDecompositionContext.rotationDegrees[2]));
        view.setRotationX(BaseViewManager.sanitizeFloatPropertyValue((float)BaseViewManager.sMatrixDecompositionContext.rotationDegrees[0]));
        view.setRotationY(BaseViewManager.sanitizeFloatPropertyValue((float)BaseViewManager.sMatrixDecompositionContext.rotationDegrees[1]));
        view.setScaleX(BaseViewManager.sanitizeFloatPropertyValue((float)BaseViewManager.sMatrixDecompositionContext.scale[0]));
        view.setScaleY(BaseViewManager.sanitizeFloatPropertyValue((float)BaseViewManager.sMatrixDecompositionContext.scale[1]));
        double[] perspectiveArray = BaseViewManager.sMatrixDecompositionContext.perspective;
        if (perspectiveArray.length > 2) {
            float invertedCameraDistance = (float)perspectiveArray[2];
            if (invertedCameraDistance == 0.0f) {
                invertedCameraDistance = 7.8125E-4f;
            }
            float cameraDistance = -1.0f / invertedCameraDistance;
            float scale = DisplayMetricsHolder.getScreenDisplayMetrics().density;
            float normalizedCameraDistance = BaseViewManager.sanitizeFloatPropertyValue(scale * scale * cameraDistance * CAMERA_DISTANCE_NORMALIZATION_MULTIPLIER);
            view.setCameraDistance(normalizedCameraDistance);
        }
    }

    private static float sanitizeFloatPropertyValue(float value) {
        if (value >= -3.4028235E38f && value <= Float.MAX_VALUE) {
            return value;
        }
        if (value < -3.4028235E38f || value == Float.NEGATIVE_INFINITY) {
            return -3.4028235E38f;
        }
        if (value > Float.MAX_VALUE || value == Float.POSITIVE_INFINITY) {
            return Float.MAX_VALUE;
        }
        if (Float.isNaN(value)) {
            return 0.0f;
        }
        throw new IllegalStateException("Invalid float property value: " + value);
    }

    private static void resetTransformProperty(@NonNull View view) {
        view.setTranslationX(PixelUtil.toPixelFromDIP(0.0f));
        view.setTranslationY(PixelUtil.toPixelFromDIP(0.0f));
        view.setRotation(0.0f);
        view.setRotationX(0.0f);
        view.setRotationY(0.0f);
        view.setScaleX(1.0f);
        view.setScaleY(1.0f);
        view.setCameraDistance(0.0f);
    }

    private void updateViewAccessibility(@NonNull T view) {
        ReactAccessibilityDelegate.setDelegate(view);
    }

    @Override
    protected void onAfterUpdateTransaction(@NonNull T view) {
        super.onAfterUpdateTransaction(view);
        this.updateViewAccessibility(view);
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.builder().put("topAccessibilityAction", MapBuilder.of("registrationName", "onAccessibilityAction")).build();
    }

    @Override
    public void setBorderRadius(T view, float borderRadius) {
        this.logUnsupportedPropertyWarning("borderRadius");
    }

    @Override
    public void setBorderBottomLeftRadius(T view, float borderRadius) {
        this.logUnsupportedPropertyWarning("borderBottomLeftRadius");
    }

    @Override
    public void setBorderBottomRightRadius(T view, float borderRadius) {
        this.logUnsupportedPropertyWarning("borderBottomRightRadius");
    }

    @Override
    public void setBorderTopLeftRadius(T view, float borderRadius) {
        this.logUnsupportedPropertyWarning("borderTopLeftRadius");
    }

    @Override
    public void setBorderTopRightRadius(T view, float borderRadius) {
        this.logUnsupportedPropertyWarning("borderTopRightRadius");
    }

    private void logUnsupportedPropertyWarning(String propName) {
        FLog.w((String)"ReactNative", (String)"%s doesn't support property '%s'", (Object[])new Object[]{this.getName(), propName});
    }

    static {
        sStateDescription.put(STATE_BUSY, R.string.state_busy_description);
        sStateDescription.put(STATE_EXPANDED, R.string.state_expanded_description);
        sStateDescription.put("collapsed", R.string.state_collapsed_description);
    }
}

