/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.touch;

import android.view.MotionEvent;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.Nullable;
import com.facebook.react.touch.OnInterceptTouchEventListener;

public class JSResponderHandler
implements OnInterceptTouchEventListener {
    private static final int JS_RESPONDER_UNSET = -1;
    private volatile int mCurrentJSResponder = -1;
    @Nullable
    private ViewParent mViewParentBlockingNativeResponder;

    public void setJSResponder(int tag, @Nullable ViewParent viewParentBlockingNativeResponder) {
        this.mCurrentJSResponder = tag;
        this.maybeUnblockNativeResponder();
        if (viewParentBlockingNativeResponder != null) {
            viewParentBlockingNativeResponder.requestDisallowInterceptTouchEvent(true);
            this.mViewParentBlockingNativeResponder = viewParentBlockingNativeResponder;
        }
    }

    public void clearJSResponder() {
        this.mCurrentJSResponder = -1;
        this.maybeUnblockNativeResponder();
    }

    private void maybeUnblockNativeResponder() {
        if (this.mViewParentBlockingNativeResponder != null) {
            this.mViewParentBlockingNativeResponder.requestDisallowInterceptTouchEvent(false);
            this.mViewParentBlockingNativeResponder = null;
        }
    }

    @Override
    public boolean onInterceptTouchEvent(ViewGroup v, MotionEvent event) {
        int currentJSResponder = this.mCurrentJSResponder;
        if (currentJSResponder != -1 && event.getAction() != 1) {
            return v.getId() == currentJSResponder;
        }
        return false;
    }
}

