/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.systeminfo;

import android.annotation.SuppressLint;
import android.app.UiModeManager;
import android.content.ContentResolver;
import android.content.res.Resources;
import android.os.Build;
import android.provider.Settings;
import androidx.annotation.Nullable;
import com.facebook.react.R;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.systeminfo.AndroidInfoHelpers;
import com.facebook.react.modules.systeminfo.ReactNativeVersion;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import java.util.HashMap;
import java.util.Map;

@ReactModule(name="PlatformConstants")
@SuppressLint(value={"HardwareIds"})
public class AndroidInfoModule
extends ReactContextBaseJavaModule
implements TurboModule {
    public static final String NAME = "PlatformConstants";
    private static final String IS_TESTING = "IS_TESTING";

    public AndroidInfoModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    private String uiMode() {
        UiModeManager uiModeManager = (UiModeManager)this.getReactApplicationContext().getSystemService("uimode");
        switch (uiModeManager.getCurrentModeType()) {
            case 4: {
                return "tv";
            }
            case 3: {
                return "car";
            }
            case 2: {
                return "desk";
            }
            case 6: {
                return "watch";
            }
            case 1: {
                return "normal";
            }
        }
        return "unknown";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    @Nullable
    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("Version", Build.VERSION.SDK_INT);
        constants.put("Release", Build.VERSION.RELEASE);
        constants.put("Serial", Build.SERIAL);
        constants.put("Fingerprint", Build.FINGERPRINT);
        constants.put("Model", Build.MODEL);
        constants.put("isTesting", "true".equals(System.getProperty(IS_TESTING)) || this.isRunningScreenshotTest() != false);
        constants.put("reactNativeVersion", ReactNativeVersion.VERSION);
        constants.put("uiMode", this.uiMode());
        return constants;
    }

    @ReactMethod(isBlockingSynchronousMethod=true)
    public String getAndroidID() {
        return Settings.Secure.getString((ContentResolver)this.getReactApplicationContext().getContentResolver(), (String)"android_id");
    }

    @Override
    public void invalidate() {
    }

    private Boolean isRunningScreenshotTest() {
        try {
            Class.forName("com.facebook.testing.react.screenshots.ReactAppScreenshotTestActivity");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private String getServerHost() {
        Resources resources = this.getReactApplicationContext().getApplicationContext().getResources();
        Integer devServerPort = resources.getInteger(R.integer.react_native_dev_server_port);
        return AndroidInfoHelpers.getServerHost(devServerPort);
    }
}

