/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.accessibilityinfo;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.DeviceEventManagerModule;

@ReactModule(name="AccessibilityInfo")
public class AccessibilityInfoModule
extends ReactContextBaseJavaModule
implements LifecycleEventListener {
    public static final String NAME = "AccessibilityInfo";
    private final ContentObserver animationScaleObserver = new ContentObserver(new Handler(Looper.getMainLooper())){

        public void onChange(boolean selfChange) {
            this.onChange(selfChange, null);
        }

        public void onChange(boolean selfChange, Uri uri) {
            if (AccessibilityInfoModule.this.getReactApplicationContext().hasActiveCatalystInstance()) {
                AccessibilityInfoModule.this.updateAndSendReduceMotionChangeEvent();
            }
        }
    };
    @Nullable
    private AccessibilityManager mAccessibilityManager;
    @Nullable
    private ReactTouchExplorationStateChangeListener mTouchExplorationStateChangeListener;
    private final ContentResolver mContentResolver;
    private boolean mReduceMotionEnabled = false;
    private boolean mTouchExplorationEnabled = false;
    private static final String REDUCE_MOTION_EVENT_NAME = "reduceMotionDidChange";
    private static final String TOUCH_EXPLORATION_EVENT_NAME = "touchExplorationDidChange";

    public AccessibilityInfoModule(ReactApplicationContext context) {
        super(context);
        Context appContext = context.getApplicationContext();
        this.mAccessibilityManager = (AccessibilityManager)appContext.getSystemService("accessibility");
        this.mContentResolver = this.getReactApplicationContext().getContentResolver();
        this.mTouchExplorationEnabled = this.mAccessibilityManager.isTouchExplorationEnabled();
        this.mReduceMotionEnabled = this.getIsReduceMotionEnabledValue();
        if (Build.VERSION.SDK_INT >= 19) {
            this.mTouchExplorationStateChangeListener = new ReactTouchExplorationStateChangeListener();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private boolean getIsReduceMotionEnabledValue() {
        String value = Build.VERSION.SDK_INT < 17 ? null : Settings.Global.getString((ContentResolver)this.mContentResolver, (String)"transition_animation_scale");
        return value != null && value.equals("0.0");
    }

    @ReactMethod
    public void isReduceMotionEnabled(Callback successCallback) {
        successCallback.invoke(this.mReduceMotionEnabled);
    }

    @ReactMethod
    public void isTouchExplorationEnabled(Callback successCallback) {
        successCallback.invoke(this.mTouchExplorationEnabled);
    }

    private void updateAndSendReduceMotionChangeEvent() {
        boolean isReduceMotionEnabled = this.getIsReduceMotionEnabledValue();
        if (this.mReduceMotionEnabled != isReduceMotionEnabled) {
            this.mReduceMotionEnabled = isReduceMotionEnabled;
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext != null) {
                reactApplicationContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit(REDUCE_MOTION_EVENT_NAME, this.mReduceMotionEnabled);
            }
        }
    }

    private void updateAndSendTouchExplorationChangeEvent(boolean enabled) {
        if (this.mTouchExplorationEnabled != enabled) {
            this.mTouchExplorationEnabled = enabled;
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext != null) {
                this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit(TOUCH_EXPLORATION_EVENT_NAME, this.mTouchExplorationEnabled);
            }
        }
    }

    @Override
    public void onHostResume() {
        if (Build.VERSION.SDK_INT >= 19) {
            this.mAccessibilityManager.addTouchExplorationStateChangeListener((AccessibilityManager.TouchExplorationStateChangeListener)this.mTouchExplorationStateChangeListener);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            Uri transitionUri = Settings.Global.getUriFor((String)"transition_animation_scale");
            this.mContentResolver.registerContentObserver(transitionUri, false, this.animationScaleObserver);
        }
        this.updateAndSendTouchExplorationChangeEvent(this.mAccessibilityManager.isTouchExplorationEnabled());
        this.updateAndSendReduceMotionChangeEvent();
    }

    @Override
    public void onHostPause() {
        if (Build.VERSION.SDK_INT >= 19) {
            this.mAccessibilityManager.removeTouchExplorationStateChangeListener((AccessibilityManager.TouchExplorationStateChangeListener)this.mTouchExplorationStateChangeListener);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            this.mContentResolver.unregisterContentObserver(this.animationScaleObserver);
        }
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().addLifecycleEventListener(this);
        this.updateAndSendTouchExplorationChangeEvent(this.mAccessibilityManager.isTouchExplorationEnabled());
        this.updateAndSendReduceMotionChangeEvent();
    }

    @Override
    public void onCatalystInstanceDestroy() {
        super.onCatalystInstanceDestroy();
        this.getReactApplicationContext().removeLifecycleEventListener(this);
    }

    @Override
    public void onHostDestroy() {
    }

    @ReactMethod
    public void announceForAccessibility(String message) {
        if (this.mAccessibilityManager == null || !this.mAccessibilityManager.isEnabled()) {
            return;
        }
        AccessibilityEvent event = AccessibilityEvent.obtain((int)16384);
        event.getText().add(message);
        event.setClassName((CharSequence)AccessibilityInfoModule.class.getName());
        event.setPackageName((CharSequence)this.getReactApplicationContext().getPackageName());
        this.mAccessibilityManager.sendAccessibilityEvent(event);
    }

    @TargetApi(value=19)
    private class ReactTouchExplorationStateChangeListener
    implements AccessibilityManager.TouchExplorationStateChangeListener {
        private ReactTouchExplorationStateChangeListener() {
        }

        public void onTouchExplorationStateChanged(boolean enabled) {
            AccessibilityInfoModule.this.updateAndSendTouchExplorationChangeEvent(enabled);
        }
    }
}

