/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting.mountitems;

import android.annotation.TargetApi;
import androidx.annotation.NonNull;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.mountitems.MountItem;

public class UpdateLayoutMountItem
implements MountItem {
    private final int mReactTag;
    private final int mX;
    private final int mY;
    private final int mWidth;
    private final int mHeight;
    private final int mLayoutDirection;

    public UpdateLayoutMountItem(int reactTag, int x, int y, int width, int height, int layoutDirection) {
        this.mReactTag = reactTag;
        this.mX = x;
        this.mY = y;
        this.mWidth = width;
        this.mHeight = height;
        this.mLayoutDirection = UpdateLayoutMountItem.convertLayoutDirection(layoutDirection);
    }

    @TargetApi(value=19)
    private static int convertLayoutDirection(int layoutDirection) {
        switch (layoutDirection) {
            case 0: {
                return 2;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unsupported layout direction: " + layoutDirection);
    }

    @Override
    public void execute(@NonNull MountingManager mountingManager) {
        mountingManager.updateLayout(this.mReactTag, this.mX, this.mY, this.mWidth, this.mHeight);
    }

    public int getX() {
        return this.mX;
    }

    public int getY() {
        return this.mY;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getLayoutDirection() {
        return this.mLayoutDirection;
    }

    public String toString() {
        return "UpdateLayoutMountItem [" + this.mReactTag + "] - x: " + this.mX + " - y: " + this.mY + " - height: " + this.mHeight + " - width: " + this.mWidth + " - layoutDirection: " + this.mLayoutDirection;
    }
}

