/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting.mountitems;

import androidx.annotation.NonNull;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.systrace.Systrace;

@DoNotStrip
public class BatchMountItem
implements MountItem {
    @NonNull
    private final MountItem[] mMountItems;
    private final int mSize;
    private final int mCommitNumber;

    public BatchMountItem(MountItem[] items, int size, int commitNumber) {
        if (items == null) {
            throw new NullPointerException();
        }
        if (size < 0 || size > items.length) {
            throw new IllegalArgumentException("Invalid size received by parameter size: " + size + " items.size = " + items.length);
        }
        this.mMountItems = items;
        this.mSize = size;
        this.mCommitNumber = commitNumber;
    }

    @Override
    public void execute(@NonNull MountingManager mountingManager) {
        Systrace.beginSection(0L, "FabricUIManager::mountViews - " + this.mSize + " items");
        if (this.mCommitNumber > 0) {
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_BATCH_EXECUTION_START, null, this.mCommitNumber);
        }
        for (int mountItemIndex = 0; mountItemIndex < this.mSize; ++mountItemIndex) {
            MountItem mountItem = this.mMountItems[mountItemIndex];
            mountItem.execute(mountingManager);
        }
        if (this.mCommitNumber > 0) {
            ReactMarker.logFabricMarker(ReactMarkerConstants.FABRIC_BATCH_EXECUTION_END, null, this.mCommitNumber);
        }
        Systrace.endSection(0L);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.mSize; ++i) {
            if (s.length() > 0) {
                s.append("\n");
            }
            s.append("BatchMountItem (").append(i + 1).append("/").append(this.mSize).append("): ").append(this.mMountItems[i]);
        }
        return s.toString();
    }
}

