/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.fabric.events.EventEmitterWrapper;
import com.facebook.react.touch.JSResponderHandler;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.RootView;
import com.facebook.react.uimanager.RootViewManager;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.yoga.YogaMeasureMode;
import java.util.concurrent.ConcurrentHashMap;

public class MountingManager {
    public static final String TAG = MountingManager.class.getSimpleName();
    @NonNull
    private final ConcurrentHashMap<Integer, ViewState> mTagToViewState;
    @NonNull
    private final JSResponderHandler mJSResponderHandler = new JSResponderHandler();
    @NonNull
    private final ViewManagerRegistry mViewManagerRegistry;
    @NonNull
    private final RootViewManager mRootViewManager = new RootViewManager();

    public MountingManager(@NonNull ViewManagerRegistry viewManagerRegistry) {
        this.mTagToViewState = new ConcurrentHashMap();
        this.mViewManagerRegistry = viewManagerRegistry;
    }

    @ThreadConfined(value="UI")
    public void addRootView(int reactRootTag, @NonNull View rootView) {
        if (rootView.getId() != -1) {
            throw new IllegalViewOperationException("Trying to add a root view with an explicit id already set. React Native uses the id field to track react tags and will overwrite this field. If that is fine, explicitly overwrite the id field to View.NO_ID before calling addRootView.");
        }
        this.mTagToViewState.put(reactRootTag, new ViewState(reactRootTag, rootView, this.mRootViewManager, true));
        rootView.setId(reactRootTag);
    }

    @UiThread
    private void dropView(@NonNull View view) {
        UiThreadUtil.assertOnUiThread();
        int reactTag = view.getId();
        ViewState state = this.getViewState(reactTag);
        ViewManager viewManager = state.mViewManager;
        if (!state.mIsRoot && viewManager != null) {
            viewManager.onDropViewInstance(view);
        }
        if (view instanceof ViewGroup && viewManager instanceof ViewGroupManager) {
            ViewGroup viewGroup = (ViewGroup)view;
            ViewGroupManager<ViewGroup> viewGroupManager = MountingManager.getViewGroupManager(state);
            for (int i = viewGroupManager.getChildCount(viewGroup) - 1; i >= 0; --i) {
                View child = viewGroupManager.getChildAt(viewGroup, i);
                if (this.getNullableViewState(child.getId()) != null) {
                    this.dropView(child);
                }
                viewGroupManager.removeViewAt(viewGroup, i);
            }
        }
        this.mTagToViewState.remove(reactTag);
    }

    @UiThread
    public void addViewAt(int parentTag, int tag, int index) {
        UiThreadUtil.assertOnUiThread();
        ViewState parentViewState = this.getViewState(parentTag);
        ViewGroup parentView = (ViewGroup)parentViewState.mView;
        ViewState viewState = this.getViewState(tag);
        View view = viewState.mView;
        if (view == null) {
            throw new IllegalStateException("Unable to find view for viewState " + viewState + " and tag " + tag);
        }
        MountingManager.getViewGroupManager(parentViewState).addView(parentView, view, index);
    }

    @NonNull
    private ViewState getViewState(int tag) {
        ViewState viewState = this.mTagToViewState.get(tag);
        if (viewState == null) {
            throw new IllegalStateException("Unable to find viewState view for tag " + tag);
        }
        return viewState;
    }

    @Nullable
    private ViewState getNullableViewState(int tag) {
        return this.mTagToViewState.get(tag);
    }

    @Deprecated
    public void receiveCommand(int reactTag, int commandId, @Nullable ReadableArray commandArgs) {
        ViewState viewState = this.getNullableViewState(reactTag);
        if (viewState == null) {
            ReactSoftException.logSoftException(TAG, new ReactNoCrashSoftException("Unable to find viewState for tag: " + reactTag + " for commandId: " + commandId));
            return;
        }
        if (viewState.mViewManager == null) {
            throw new IllegalStateException("Unable to find viewManager for tag " + reactTag);
        }
        if (viewState.mView == null) {
            throw new IllegalStateException("Unable to find viewState view for tag " + reactTag);
        }
        viewState.mViewManager.receiveCommand(viewState.mView, commandId, commandArgs);
    }

    public void receiveCommand(int reactTag, @NonNull String commandId, @Nullable ReadableArray commandArgs) {
        ViewState viewState = this.getNullableViewState(reactTag);
        if (viewState == null) {
            ReactSoftException.logSoftException(TAG, new IllegalStateException("Unable to find viewState for tag: " + reactTag + " for commandId: " + commandId));
            return;
        }
        if (viewState.mViewManager == null) {
            throw new IllegalStateException("Unable to find viewState manager for tag " + reactTag);
        }
        if (viewState.mView == null) {
            throw new IllegalStateException("Unable to find viewState view for tag " + reactTag);
        }
        viewState.mViewManager.receiveCommand(viewState.mView, commandId, commandArgs);
    }

    public void sendAccessibilityEvent(int reactTag, int eventType) {
        ViewState viewState = this.getViewState(reactTag);
        if (viewState.mViewManager == null) {
            throw new IllegalStateException("Unable to find viewState manager for tag " + reactTag);
        }
        if (viewState.mView == null) {
            throw new IllegalStateException("Unable to find viewState view for tag " + reactTag);
        }
        viewState.mView.sendAccessibilityEvent(eventType);
    }

    @NonNull
    private static ViewGroupManager<ViewGroup> getViewGroupManager(@NonNull ViewState viewState) {
        if (viewState.mViewManager == null) {
            throw new IllegalStateException("Unable to find ViewManager for view: " + viewState);
        }
        return (ViewGroupManager)viewState.mViewManager;
    }

    @UiThread
    public void removeViewAt(int parentTag, int index) {
        UiThreadUtil.assertOnUiThread();
        ViewState viewState = this.getNullableViewState(parentTag);
        if (viewState == null) {
            ReactSoftException.logSoftException(TAG, new IllegalStateException("Unable to find viewState for tag: " + parentTag + " for removeViewAt"));
            return;
        }
        ViewGroup parentView = (ViewGroup)viewState.mView;
        if (parentView == null) {
            throw new IllegalStateException("Unable to find view for tag " + parentTag);
        }
        MountingManager.getViewGroupManager(viewState).removeViewAt(parentView, index);
    }

    @UiThread
    public void createView(@NonNull ThemedReactContext themedReactContext, @NonNull String componentName, int reactTag, @Nullable ReadableMap props, @Nullable StateWrapper stateWrapper, boolean isLayoutable) {
        if (this.getNullableViewState(reactTag) != null) {
            return;
        }
        View view = null;
        ViewManager viewManager = null;
        ReactStylesDiffMap propsDiffMap = null;
        if (props != null) {
            propsDiffMap = new ReactStylesDiffMap(props);
        }
        if (isLayoutable) {
            viewManager = this.mViewManagerRegistry.get(componentName);
            view = (View)viewManager.createView(themedReactContext, propsDiffMap, stateWrapper, this.mJSResponderHandler);
            view.setId(reactTag);
        }
        ViewState viewState = new ViewState(reactTag, view, viewManager);
        viewState.mCurrentProps = propsDiffMap;
        viewState.mCurrentState = stateWrapper != null ? stateWrapper.getState() : null;
        this.mTagToViewState.put(reactTag, viewState);
    }

    @UiThread
    public void updateProps(int reactTag, @Nullable ReadableMap props) {
        if (props == null) {
            return;
        }
        UiThreadUtil.assertOnUiThread();
        ViewState viewState = this.getViewState(reactTag);
        viewState.mCurrentProps = new ReactStylesDiffMap(props);
        View view = viewState.mView;
        if (view == null) {
            throw new IllegalStateException("Unable to find view for tag " + reactTag);
        }
        ((ViewManager)Assertions.assertNotNull((Object)viewState.mViewManager)).updateProperties(view, viewState.mCurrentProps);
    }

    @UiThread
    public void updateLayout(int reactTag, int x, int y, int width, int height) {
        UiThreadUtil.assertOnUiThread();
        ViewState viewState = this.getViewState(reactTag);
        if (viewState.mIsRoot) {
            return;
        }
        View viewToUpdate = viewState.mView;
        if (viewToUpdate == null) {
            throw new IllegalStateException("Unable to find View for tag: " + reactTag);
        }
        viewToUpdate.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        ViewParent parent = viewToUpdate.getParent();
        if (parent instanceof RootView) {
            parent.requestLayout();
        }
        viewToUpdate.layout(x, y, x + width, y + height);
    }

    @UiThread
    public void updatePadding(int reactTag, int left, int top, int right, int bottom) {
        UiThreadUtil.assertOnUiThread();
        ViewState viewState = this.getViewState(reactTag);
        if (viewState.mIsRoot) {
            return;
        }
        View viewToUpdate = viewState.mView;
        if (viewToUpdate == null) {
            throw new IllegalStateException("Unable to find View for tag: " + reactTag);
        }
        ViewManager viewManager = viewState.mViewManager;
        if (viewManager == null) {
            throw new IllegalStateException("Unable to find ViewManager for view: " + viewState);
        }
        viewManager.setPadding(viewToUpdate, left, top, right, bottom);
    }

    @UiThread
    public void deleteView(int reactTag) {
        UiThreadUtil.assertOnUiThread();
        ViewState viewState = this.getNullableViewState(reactTag);
        if (viewState == null) {
            ReactSoftException.logSoftException(TAG, new IllegalStateException("Unable to find viewState for tag: " + reactTag + " for deleteView"));
            return;
        }
        View view = viewState.mView;
        if (view != null) {
            this.dropView(view);
        } else {
            this.mTagToViewState.remove(reactTag);
        }
    }

    @UiThread
    public void updateLocalData(int reactTag, @NonNull ReadableMap newLocalData) {
        UiThreadUtil.assertOnUiThread();
        ViewState viewState = this.getViewState(reactTag);
        if (viewState.mCurrentProps == null) {
            throw new IllegalStateException("Can not update local data to view without props: " + reactTag);
        }
        if (viewState.mCurrentLocalData != null && newLocalData.hasKey("hash") && viewState.mCurrentLocalData.getDouble("hash") == newLocalData.getDouble("hash") && viewState.mCurrentLocalData.equals(newLocalData)) {
            return;
        }
        viewState.mCurrentLocalData = newLocalData;
        ViewManager viewManager = viewState.mViewManager;
        if (viewManager == null) {
            throw new IllegalStateException("Unable to find ViewManager for view: " + viewState);
        }
        Object extraData = viewManager.updateLocalData(viewState.mView, viewState.mCurrentProps, new ReactStylesDiffMap(viewState.mCurrentLocalData));
        if (extraData != null) {
            viewManager.updateExtraData(viewState.mView, extraData);
        }
    }

    @UiThread
    public void updateState(int reactTag, @Nullable StateWrapper stateWrapper) {
        ReadableNativeMap newState;
        UiThreadUtil.assertOnUiThread();
        ViewState viewState = this.getViewState(reactTag);
        ReadableNativeMap readableNativeMap = newState = stateWrapper == null ? null : stateWrapper.getState();
        if (viewState.mCurrentState != null && viewState.mCurrentState.equals(newState) || viewState.mCurrentState == null && stateWrapper == null) {
            return;
        }
        viewState.mCurrentState = newState;
        ViewManager viewManager = viewState.mViewManager;
        if (viewManager == null) {
            throw new IllegalStateException("Unable to find ViewManager for tag: " + reactTag);
        }
        Object extraData = viewManager.updateState(viewState.mView, viewState.mCurrentProps, stateWrapper);
        if (extraData != null) {
            viewManager.updateExtraData(viewState.mView, extraData);
        }
    }

    @UiThread
    public void preallocateView(@NonNull ThemedReactContext reactContext, String componentName, int reactTag, @Nullable ReadableMap props, @Nullable StateWrapper stateWrapper, boolean isLayoutable) {
        if (this.getNullableViewState(reactTag) != null) {
            throw new IllegalStateException("View for component " + componentName + " with tag " + reactTag + " already exists.");
        }
        this.createView(reactContext, componentName, reactTag, props, stateWrapper, isLayoutable);
    }

    @UiThread
    public void updateEventEmitter(int reactTag, @NonNull EventEmitterWrapper eventEmitter) {
        UiThreadUtil.assertOnUiThread();
        ViewState viewState = this.getViewState(reactTag);
        viewState.mEventEmitter = eventEmitter;
    }

    @UiThread
    public synchronized void setJSResponder(int reactTag, int initialReactTag, boolean blockNativeResponder) {
        if (!blockNativeResponder) {
            this.mJSResponderHandler.setJSResponder(initialReactTag, null);
            return;
        }
        ViewState viewState = this.getViewState(reactTag);
        View view = viewState.mView;
        if (initialReactTag != reactTag && view instanceof ViewParent) {
            this.mJSResponderHandler.setJSResponder(initialReactTag, (ViewParent)view);
            return;
        }
        if (view == null) {
            SoftAssertions.assertUnreachable("Cannot find view for tag " + reactTag + ".");
            return;
        }
        if (viewState.mIsRoot) {
            SoftAssertions.assertUnreachable("Cannot block native responder on " + reactTag + " that is a root view");
        }
        this.mJSResponderHandler.setJSResponder(initialReactTag, view.getParent());
    }

    @UiThread
    public void clearJSResponder() {
        this.mJSResponderHandler.clearJSResponder();
    }

    @AnyThread
    public long measure(@NonNull Context context, @NonNull String componentName, @NonNull ReadableMap localData, @NonNull ReadableMap props, @NonNull ReadableMap state, float width, @NonNull YogaMeasureMode widthMode, float height, @NonNull YogaMeasureMode heightMode) {
        return this.mViewManagerRegistry.get(componentName).measure(context, localData, props, state, width, widthMode, height, heightMode);
    }

    @AnyThread
    @ThreadConfined(value="ANY")
    @Nullable
    public EventEmitterWrapper getEventEmitter(int reactTag) {
        ViewState viewState = this.getNullableViewState(reactTag);
        return viewState == null ? null : viewState.mEventEmitter;
    }

    private static class ViewState {
        @Nullable
        final View mView;
        final int mReactTag;
        final boolean mIsRoot;
        @Nullable
        final ViewManager mViewManager;
        @Nullable
        public ReactStylesDiffMap mCurrentProps = null;
        @Nullable
        public ReadableMap mCurrentLocalData = null;
        @Nullable
        public ReadableMap mCurrentState = null;
        @Nullable
        public EventEmitterWrapper mEventEmitter = null;

        private ViewState(int reactTag, @Nullable View view, @Nullable ViewManager viewManager) {
            this(reactTag, view, viewManager, false);
        }

        private ViewState(int reactTag, @Nullable View view, ViewManager viewManager, boolean isRoot) {
            this.mReactTag = reactTag;
            this.mView = view;
            this.mIsRoot = isRoot;
            this.mViewManager = viewManager;
        }

        public String toString() {
            boolean isLayoutOnly = this.mViewManager == null;
            return "ViewState [" + this.mReactTag + "] - isRoot: " + this.mIsRoot + " - props: " + this.mCurrentProps + " - localData: " + this.mCurrentLocalData + " - viewManager: " + this.mViewManager + " - isLayoutOnly: " + isLayoutOnly;
        }
    }
}

