/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.devsupport.LogBoxDialog;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.module.annotations.ReactModule;

@ReactModule(name="LogBox")
public class LogBoxModule
extends ReactContextBaseJavaModule {
    public static final String NAME = "LogBox";
    private final DevSupportManager mDevSupportManager;
    @Nullable
    private View mReactRootView;
    @Nullable
    private LogBoxDialog mLogBoxDialog;

    public LogBoxModule(ReactApplicationContext reactContext, DevSupportManager devSupportManager) {
        super(reactContext);
        this.mDevSupportManager = devSupportManager;
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (LogBoxModule.this.mReactRootView == null) {
                    LogBoxModule.this.mReactRootView = LogBoxModule.this.mDevSupportManager.createRootView(LogBoxModule.NAME);
                    if (LogBoxModule.this.mReactRootView == null) {
                        FLog.e((String)"ReactNative", (String)"Unable to launch logbox because react was unable to create the root view");
                    }
                }
            }
        });
    }

    @Override
    public String getName() {
        return NAME;
    }

    @ReactMethod
    public void show() {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (LogBoxModule.this.mLogBoxDialog == null) {
                    Activity context = LogBoxModule.this.getCurrentActivity();
                    if (context == null || context.isFinishing()) {
                        FLog.e((String)"ReactNative", (String)"Unable to launch logbox because react activity is not available, here is the error that logbox would've displayed: ");
                        return;
                    }
                    LogBoxModule.this.mLogBoxDialog = new LogBoxDialog(context, LogBoxModule.this.mReactRootView);
                    LogBoxModule.this.mLogBoxDialog.setCancelable(false);
                    LogBoxModule.this.mLogBoxDialog.show();
                }
            }
        });
    }

    @ReactMethod
    public void hide() {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (LogBoxModule.this.mLogBoxDialog != null) {
                    if (LogBoxModule.this.mReactRootView.getParent() != null) {
                        ((ViewGroup)LogBoxModule.this.mReactRootView.getParent()).removeView(LogBoxModule.this.mReactRootView);
                    }
                    LogBoxModule.this.mLogBoxDialog.dismiss();
                    LogBoxModule.this.mLogBoxDialog = null;
                }
            }
        });
    }

    @Override
    public void onCatalystInstanceDestroy() {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (LogBoxModule.this.mReactRootView != null) {
                    LogBoxModule.this.mDevSupportManager.destroyRootView(LogBoxModule.this.mReactRootView);
                    LogBoxModule.this.mReactRootView = null;
                }
            }
        });
    }
}

