/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.SensorManager;
import android.util.Pair;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.debug.holder.PrinterHolder;
import com.facebook.debug.tags.ReactDebugOverlayTags;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.R;
import com.facebook.react.bridge.DefaultNativeModuleCallExceptionHandler;
import com.facebook.react.bridge.JavaJSExecutor;
import com.facebook.react.bridge.JavaScriptExecutorFactory;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.DebugServerException;
import com.facebook.react.common.ShakeDetector;
import com.facebook.react.common.futures.SimpleSettableFuture;
import com.facebook.react.devsupport.BundleDownloader;
import com.facebook.react.devsupport.DebugOverlayController;
import com.facebook.react.devsupport.DevInternalSettings;
import com.facebook.react.devsupport.DevLoadingViewController;
import com.facebook.react.devsupport.DevServerHelper;
import com.facebook.react.devsupport.DevSettingsActivity;
import com.facebook.react.devsupport.HMRClient;
import com.facebook.react.devsupport.InspectorPackagerConnection;
import com.facebook.react.devsupport.JSCHeapCapture;
import com.facebook.react.devsupport.JSException;
import com.facebook.react.devsupport.ReactInstanceManagerDevHelper;
import com.facebook.react.devsupport.RedBoxDialog;
import com.facebook.react.devsupport.RedBoxHandler;
import com.facebook.react.devsupport.StackTraceHelper;
import com.facebook.react.devsupport.WebsocketJavaScriptExecutor;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import com.facebook.react.devsupport.interfaces.DevOptionHandler;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.devsupport.interfaces.ErrorCustomizer;
import com.facebook.react.devsupport.interfaces.PackagerStatusCallback;
import com.facebook.react.devsupport.interfaces.StackFrame;
import com.facebook.react.modules.core.RCTNativeAppEventEmitter;
import com.facebook.react.modules.debug.interfaces.DeveloperSettings;
import com.facebook.react.packagerconnection.RequestHandler;
import com.facebook.react.packagerconnection.Responder;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DevSupportManagerImpl
implements DevSupportManager,
DevServerHelper.PackagerCommandListener,
DevInternalSettings.Listener {
    private static final int JAVA_ERROR_COOKIE = -1;
    private static final int JSEXCEPTION_ERROR_COOKIE = -1;
    private static final String JS_BUNDLE_FILE_NAME = "ReactNativeDevBundle.js";
    private static final String RELOAD_APP_ACTION_SUFFIX = ".RELOAD_APP_ACTION";
    private boolean mIsSamplingProfilerEnabled = false;
    private static final String EXOPACKAGE_LOCATION_FORMAT = "/data/local/tmp/exopackage/%s//secondary-dex";
    public static final String EMOJI_HUNDRED_POINTS_SYMBOL = " \ud83d\udcaf";
    public static final String EMOJI_FACE_WITH_NO_GOOD_GESTURE = " \ud83d\ude45";
    private final List<ExceptionLogger> mExceptionLoggers = new ArrayList<ExceptionLogger>();
    private final Context mApplicationContext;
    private final ShakeDetector mShakeDetector;
    private final BroadcastReceiver mReloadAppBroadcastReceiver;
    private final DevServerHelper mDevServerHelper;
    private final LinkedHashMap<String, DevOptionHandler> mCustomDevOptions = new LinkedHashMap();
    private final ReactInstanceManagerDevHelper mReactInstanceManagerHelper;
    @Nullable
    private final String mJSAppBundleName;
    private final File mJSBundleTempFile;
    private final DefaultNativeModuleCallExceptionHandler mDefaultNativeModuleCallExceptionHandler;
    private final DevLoadingViewController mDevLoadingViewController;
    @Nullable
    private RedBoxDialog mRedBoxDialog;
    @Nullable
    private AlertDialog mDevOptionsDialog;
    @Nullable
    private DebugOverlayController mDebugOverlayController;
    private boolean mDevLoadingViewVisible = false;
    @Nullable
    private ReactContext mCurrentContext;
    private DevInternalSettings mDevSettings;
    private boolean mIsReceiverRegistered = false;
    private boolean mIsShakeDetectorStarted = false;
    private boolean mIsDevSupportEnabled = false;
    @Nullable
    private RedBoxHandler mRedBoxHandler;
    @Nullable
    private String mLastErrorTitle;
    @Nullable
    private StackFrame[] mLastErrorStack;
    private int mLastErrorCookie = 0;
    @Nullable
    private ErrorType mLastErrorType;
    @Nullable
    private DevBundleDownloadListener mBundleDownloadListener;
    @Nullable
    private List<ErrorCustomizer> mErrorCustomizers;
    private InspectorPackagerConnection.BundleStatus mBundleStatus;
    @Nullable
    private Map<String, RequestHandler> mCustomPackagerCommandHandlers;

    public DevSupportManagerImpl(Context applicationContext, ReactInstanceManagerDevHelper reactInstanceManagerHelper, @Nullable String packagerPathForJSBundleName, boolean enableOnCreate, int minNumShakes) {
        this(applicationContext, reactInstanceManagerHelper, packagerPathForJSBundleName, enableOnCreate, null, null, minNumShakes, null);
    }

    public DevSupportManagerImpl(Context applicationContext, ReactInstanceManagerDevHelper reactInstanceManagerHelper, @Nullable String packagerPathForJSBundleName, boolean enableOnCreate, @Nullable RedBoxHandler redBoxHandler, @Nullable DevBundleDownloadListener devBundleDownloadListener, int minNumShakes, @Nullable Map<String, RequestHandler> customPackagerCommandHandlers) {
        this.mReactInstanceManagerHelper = reactInstanceManagerHelper;
        this.mApplicationContext = applicationContext;
        this.mJSAppBundleName = packagerPathForJSBundleName;
        this.mDevSettings = new DevInternalSettings(applicationContext, this);
        this.mBundleStatus = new InspectorPackagerConnection.BundleStatus();
        this.mDevServerHelper = new DevServerHelper(this.mDevSettings, this.mApplicationContext.getPackageName(), new InspectorPackagerConnection.BundleStatusProvider(){

            @Override
            public InspectorPackagerConnection.BundleStatus getBundleStatus() {
                return DevSupportManagerImpl.this.mBundleStatus;
            }
        });
        this.mBundleDownloadListener = devBundleDownloadListener;
        this.mShakeDetector = new ShakeDetector(new ShakeDetector.ShakeListener(){

            @Override
            public void onShake() {
                DevSupportManagerImpl.this.showDevOptionsDialog();
            }
        }, minNumShakes);
        this.mCustomPackagerCommandHandlers = customPackagerCommandHandlers;
        this.mReloadAppBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (DevSupportManagerImpl.getReloadAppAction(context).equals(action)) {
                    if (intent.getBooleanExtra("jsproxy", false)) {
                        DevSupportManagerImpl.this.mDevSettings.setRemoteJSDebugEnabled(true);
                        DevSupportManagerImpl.this.mDevServerHelper.launchJSDevtools();
                    } else {
                        DevSupportManagerImpl.this.mDevSettings.setRemoteJSDebugEnabled(false);
                    }
                    DevSupportManagerImpl.this.handleReloadJS();
                }
            }
        };
        this.mJSBundleTempFile = new File(applicationContext.getFilesDir(), JS_BUNDLE_FILE_NAME);
        this.mDefaultNativeModuleCallExceptionHandler = new DefaultNativeModuleCallExceptionHandler();
        this.setDevSupportEnabled(enableOnCreate);
        this.mRedBoxHandler = redBoxHandler;
        this.mDevLoadingViewController = new DevLoadingViewController(applicationContext, reactInstanceManagerHelper);
        this.mExceptionLoggers.add(new JSExceptionLogger());
        if (this.mDevSettings.isStartSamplingProfilerOnInit()) {
            if (!this.mIsSamplingProfilerEnabled) {
                this.toggleJSSamplingProfiler();
            } else {
                Toast.makeText((Context)this.mApplicationContext, (CharSequence)"JS Sampling Profiler was already running, so did not start the sampling profiler", (int)1).show();
            }
        }
    }

    @Override
    public void handleException(Exception e) {
        if (this.mIsDevSupportEnabled) {
            for (ExceptionLogger logger : this.mExceptionLoggers) {
                logger.log(e);
            }
        } else {
            this.mDefaultNativeModuleCallExceptionHandler.handleException(e);
        }
    }

    @Override
    public void showNewJavaError(@Nullable String message, Throwable e) {
        FLog.e((String)"ReactNative", (String)"Exception in native call", (Throwable)e);
        this.showNewError(message, StackTraceHelper.convertJavaStackTrace(e), -1, ErrorType.NATIVE);
    }

    @Override
    public void addCustomDevOption(String optionName, DevOptionHandler optionHandler) {
        this.mCustomDevOptions.put(optionName, optionHandler);
    }

    @Override
    public void showNewJSError(String message, ReadableArray details, int errorCookie) {
        this.showNewError(message, StackTraceHelper.convertJsStackTrace(details), errorCookie, ErrorType.JS);
    }

    @Override
    public void registerErrorCustomizer(ErrorCustomizer errorCustomizer) {
        if (this.mErrorCustomizers == null) {
            this.mErrorCustomizers = new ArrayList<ErrorCustomizer>();
        }
        this.mErrorCustomizers.add(errorCustomizer);
    }

    private Pair<String, StackFrame[]> processErrorCustomizers(Pair<String, StackFrame[]> errorInfo) {
        if (this.mErrorCustomizers == null) {
            return errorInfo;
        }
        for (ErrorCustomizer errorCustomizer : this.mErrorCustomizers) {
            Pair<String, StackFrame[]> result = errorCustomizer.customizeErrorInfo(errorInfo);
            if (result == null) continue;
            errorInfo = result;
        }
        return errorInfo;
    }

    @Override
    public void updateJSError(final String message, final ReadableArray details, final int errorCookie) {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (DevSupportManagerImpl.this.mRedBoxDialog == null || !DevSupportManagerImpl.this.mRedBoxDialog.isShowing() || errorCookie != DevSupportManagerImpl.this.mLastErrorCookie) {
                    return;
                }
                StackFrame[] stack = StackTraceHelper.convertJsStackTrace(details);
                Pair errorInfo = DevSupportManagerImpl.this.processErrorCustomizers((Pair<String, StackFrame[]>)Pair.create((Object)message, (Object)stack));
                DevSupportManagerImpl.this.mRedBoxDialog.setExceptionDetails((String)errorInfo.first, (StackFrame[])errorInfo.second);
                DevSupportManagerImpl.this.updateLastErrorInfo(message, stack, errorCookie, ErrorType.JS);
                if (DevSupportManagerImpl.this.mRedBoxHandler != null) {
                    DevSupportManagerImpl.this.mRedBoxHandler.handleRedbox(message, stack, RedBoxHandler.ErrorType.JS);
                    DevSupportManagerImpl.this.mRedBoxDialog.resetReporting();
                }
                DevSupportManagerImpl.this.mRedBoxDialog.show();
            }
        });
    }

    @Override
    public void hideRedboxDialog() {
        if (this.mRedBoxDialog != null) {
            this.mRedBoxDialog.dismiss();
            this.mRedBoxDialog = null;
        }
    }

    @Override
    @Nullable
    public View createRootView(String appKey) {
        return this.mReactInstanceManagerHelper.createRootView(appKey);
    }

    @Override
    public void destroyRootView(View rootView) {
        this.mReactInstanceManagerHelper.destroyRootView(rootView);
    }

    private void hideDevOptionsDialog() {
        if (this.mDevOptionsDialog != null) {
            this.mDevOptionsDialog.dismiss();
            this.mDevOptionsDialog = null;
        }
    }

    private void showNewError(final @Nullable String message, final StackFrame[] stack, final int errorCookie, final ErrorType errorType) {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (DevSupportManagerImpl.this.mRedBoxDialog == null) {
                    Activity context = DevSupportManagerImpl.this.mReactInstanceManagerHelper.getCurrentActivity();
                    if (context == null || context.isFinishing()) {
                        FLog.e((String)"ReactNative", (String)("Unable to launch redbox because react activity is not available, here is the error that redbox would've displayed: " + message));
                        return;
                    }
                    DevSupportManagerImpl.this.mRedBoxDialog = new RedBoxDialog((Context)context, DevSupportManagerImpl.this, DevSupportManagerImpl.this.mRedBoxHandler);
                }
                if (DevSupportManagerImpl.this.mRedBoxDialog.isShowing()) {
                    return;
                }
                Pair errorInfo = DevSupportManagerImpl.this.processErrorCustomizers((Pair<String, StackFrame[]>)Pair.create((Object)message, (Object)stack));
                DevSupportManagerImpl.this.mRedBoxDialog.setExceptionDetails((String)errorInfo.first, (StackFrame[])errorInfo.second);
                DevSupportManagerImpl.this.updateLastErrorInfo(message, stack, errorCookie, errorType);
                if (DevSupportManagerImpl.this.mRedBoxHandler != null && errorType == ErrorType.NATIVE) {
                    DevSupportManagerImpl.this.mRedBoxHandler.handleRedbox(message, stack, RedBoxHandler.ErrorType.NATIVE);
                }
                DevSupportManagerImpl.this.mRedBoxDialog.resetReporting();
                DevSupportManagerImpl.this.mRedBoxDialog.show();
            }
        });
    }

    @Override
    public void showDevOptionsDialog() {
        if (this.mDevOptionsDialog != null || !this.mIsDevSupportEnabled || ActivityManager.isUserAMonkey()) {
            return;
        }
        LinkedHashMap<String, DevOptionHandler> options = new LinkedHashMap<String, DevOptionHandler>();
        options.put(this.mApplicationContext.getString(R.string.catalyst_reload), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                if (!DevSupportManagerImpl.this.mDevSettings.isJSDevModeEnabled() && DevSupportManagerImpl.this.mDevSettings.isHotModuleReplacementEnabled()) {
                    Toast.makeText((Context)DevSupportManagerImpl.this.mApplicationContext, (CharSequence)DevSupportManagerImpl.this.mApplicationContext.getString(R.string.catalyst_hot_reloading_auto_disable), (int)1).show();
                    DevSupportManagerImpl.this.mDevSettings.setHotModuleReplacementEnabled(false);
                }
                DevSupportManagerImpl.this.handleReloadJS();
            }
        });
        options.put(this.mDevSettings.isNuclideJSDebugEnabled() ? (this.mDevSettings.isRemoteJSDebugEnabled() ? this.mApplicationContext.getString(R.string.catalyst_debug_chrome_stop) : this.mApplicationContext.getString(R.string.catalyst_debug_chrome)) : (this.mDevSettings.isRemoteJSDebugEnabled() ? this.mApplicationContext.getString(R.string.catalyst_debug_stop) : this.mApplicationContext.getString(R.string.catalyst_debug)), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                DevSupportManagerImpl.this.mDevSettings.setRemoteJSDebugEnabled(!DevSupportManagerImpl.this.mDevSettings.isRemoteJSDebugEnabled());
                DevSupportManagerImpl.this.handleReloadJS();
            }
        });
        if (this.mDevSettings.isNuclideJSDebugEnabled()) {
            options.put(this.mApplicationContext.getString(R.string.catalyst_debug_nuclide), new DevOptionHandler(){

                @Override
                public void onOptionSelected() {
                    DevSupportManagerImpl.this.mDevServerHelper.attachDebugger(DevSupportManagerImpl.this.mApplicationContext, "ReactNative");
                }
            });
        }
        options.put(this.mApplicationContext.getString(R.string.catalyst_change_bundle_location), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                Activity context = DevSupportManagerImpl.this.mReactInstanceManagerHelper.getCurrentActivity();
                if (context == null || context.isFinishing()) {
                    FLog.e((String)"ReactNative", (String)"Unable to launch change bundle location because react activity is not available");
                    return;
                }
                final EditText input = new EditText((Context)context);
                input.setHint((CharSequence)"localhost:8081");
                AlertDialog bundleLocationDialog = new AlertDialog.Builder((Context)context).setTitle((CharSequence)DevSupportManagerImpl.this.mApplicationContext.getString(R.string.catalyst_change_bundle_location)).setView((View)input).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        String host = input.getText().toString();
                        DevSupportManagerImpl.this.mDevSettings.getPackagerConnectionSettings().setDebugServerHost(host);
                        DevSupportManagerImpl.this.handleReloadJS();
                    }
                }).create();
                bundleLocationDialog.show();
            }
        });
        options.put(this.mApplicationContext.getString(R.string.catalyst_inspector), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                DevSupportManagerImpl.this.mDevSettings.setElementInspectorEnabled(!DevSupportManagerImpl.this.mDevSettings.isElementInspectorEnabled());
                DevSupportManagerImpl.this.mReactInstanceManagerHelper.toggleElementInspector();
            }
        });
        options.put(this.mDevSettings.isHotModuleReplacementEnabled() ? this.mApplicationContext.getString(R.string.catalyst_hot_reloading_stop) : this.mApplicationContext.getString(R.string.catalyst_hot_reloading), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                boolean nextEnabled = !DevSupportManagerImpl.this.mDevSettings.isHotModuleReplacementEnabled();
                DevSupportManagerImpl.this.mDevSettings.setHotModuleReplacementEnabled(nextEnabled);
                if (DevSupportManagerImpl.this.mCurrentContext != null) {
                    if (nextEnabled) {
                        DevSupportManagerImpl.this.mCurrentContext.getJSModule(HMRClient.class).enable();
                    } else {
                        DevSupportManagerImpl.this.mCurrentContext.getJSModule(HMRClient.class).disable();
                    }
                }
                if (nextEnabled && !DevSupportManagerImpl.this.mDevSettings.isJSDevModeEnabled()) {
                    Toast.makeText((Context)DevSupportManagerImpl.this.mApplicationContext, (CharSequence)DevSupportManagerImpl.this.mApplicationContext.getString(R.string.catalyst_hot_reloading_auto_enable), (int)1).show();
                    DevSupportManagerImpl.this.mDevSettings.setJSDevModeEnabled(true);
                    DevSupportManagerImpl.this.handleReloadJS();
                }
            }
        });
        options.put(this.mIsSamplingProfilerEnabled ? this.mApplicationContext.getString(R.string.catalyst_sample_profiler_disable) : this.mApplicationContext.getString(R.string.catalyst_sample_profiler_enable), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                DevSupportManagerImpl.this.toggleJSSamplingProfiler();
            }
        });
        options.put(this.mDevSettings.isFpsDebugEnabled() ? this.mApplicationContext.getString(R.string.catalyst_perf_monitor_stop) : this.mApplicationContext.getString(R.string.catalyst_perf_monitor), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                if (!DevSupportManagerImpl.this.mDevSettings.isFpsDebugEnabled()) {
                    Activity context = DevSupportManagerImpl.this.mReactInstanceManagerHelper.getCurrentActivity();
                    if (context == null) {
                        FLog.e((String)"ReactNative", (String)"Unable to get reference to react activity");
                    } else {
                        DebugOverlayController.requestPermission((Context)context);
                    }
                }
                DevSupportManagerImpl.this.mDevSettings.setFpsDebugEnabled(!DevSupportManagerImpl.this.mDevSettings.isFpsDebugEnabled());
            }
        });
        options.put(this.mApplicationContext.getString(R.string.catalyst_settings), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                Intent intent = new Intent(DevSupportManagerImpl.this.mApplicationContext, DevSettingsActivity.class);
                intent.setFlags(0x10000000);
                DevSupportManagerImpl.this.mApplicationContext.startActivity(intent);
            }
        });
        if (this.mCustomDevOptions.size() > 0) {
            options.putAll(this.mCustomDevOptions);
        }
        final DevOptionHandler[] optionHandlers = options.values().toArray(new DevOptionHandler[0]);
        Activity context = this.mReactInstanceManagerHelper.getCurrentActivity();
        if (context == null || context.isFinishing()) {
            FLog.e((String)"ReactNative", (String)"Unable to launch dev options menu because react activity isn't available");
            return;
        }
        this.mDevOptionsDialog = new AlertDialog.Builder((Context)context).setItems((CharSequence[])options.keySet().toArray(new String[0]), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                optionHandlers[which].onOptionSelected();
                DevSupportManagerImpl.this.mDevOptionsDialog = null;
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                DevSupportManagerImpl.this.mDevOptionsDialog = null;
            }
        }).create();
        this.mDevOptionsDialog.show();
        if (this.mCurrentContext != null) {
            this.mCurrentContext.getJSModule(RCTNativeAppEventEmitter.class).emit("RCTDevMenuShown", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toggleJSSamplingProfiler() {
        JavaScriptExecutorFactory javaScriptExecutorFactory = this.mReactInstanceManagerHelper.getJavaScriptExecutorFactory();
        if (!this.mIsSamplingProfilerEnabled) {
            try {
                javaScriptExecutorFactory.startSamplingProfiler();
                Toast.makeText((Context)this.mApplicationContext, (CharSequence)"Starting Sampling Profiler", (int)0).show();
            }
            catch (UnsupportedOperationException e) {
                Toast.makeText((Context)this.mApplicationContext, (CharSequence)(javaScriptExecutorFactory.toString() + " does not support Sampling Profiler"), (int)1).show();
            }
            finally {
                this.mIsSamplingProfilerEnabled = true;
            }
        } else {
            try {
                String outputPath = File.createTempFile("sampling-profiler-trace", ".cpuprofile", this.mApplicationContext.getCacheDir()).getPath();
                javaScriptExecutorFactory.stopSamplingProfiler(outputPath);
                Toast.makeText((Context)this.mApplicationContext, (CharSequence)("Saved results from Profiler to " + outputPath), (int)1).show();
            }
            catch (IOException e) {
                FLog.e((String)"ReactNative", (String)"Could not create temporary file for saving results from Sampling Profiler");
            }
            catch (UnsupportedOperationException e) {
                Toast.makeText((Context)this.mApplicationContext, (CharSequence)(javaScriptExecutorFactory.toString() + "does not support Sampling Profiler"), (int)1).show();
            }
            finally {
                this.mIsSamplingProfilerEnabled = false;
            }
        }
    }

    @Override
    public void setDevSupportEnabled(boolean isDevSupportEnabled) {
        this.mIsDevSupportEnabled = isDevSupportEnabled;
        this.reloadSettings();
    }

    @Override
    public boolean getDevSupportEnabled() {
        return this.mIsDevSupportEnabled;
    }

    @Override
    public DeveloperSettings getDevSettings() {
        return this.mDevSettings;
    }

    @Override
    public void onNewReactContextCreated(ReactContext reactContext) {
        this.resetCurrentContext(reactContext);
    }

    @Override
    public void onReactInstanceDestroyed(ReactContext reactContext) {
        if (reactContext == this.mCurrentContext) {
            this.resetCurrentContext(null);
        }
    }

    @Override
    public String getSourceMapUrl() {
        if (this.mJSAppBundleName == null) {
            return "";
        }
        return this.mDevServerHelper.getSourceMapUrl((String)Assertions.assertNotNull((Object)this.mJSAppBundleName));
    }

    @Override
    public String getSourceUrl() {
        if (this.mJSAppBundleName == null) {
            return "";
        }
        return this.mDevServerHelper.getSourceUrl((String)Assertions.assertNotNull((Object)this.mJSAppBundleName));
    }

    @Override
    public String getJSBundleURLForRemoteDebugging() {
        return this.mDevServerHelper.getJSBundleURLForRemoteDebugging((String)Assertions.assertNotNull((Object)this.mJSAppBundleName));
    }

    @Override
    public String getDownloadedJSBundleFile() {
        return this.mJSBundleTempFile.getAbsolutePath();
    }

    @Override
    public boolean hasUpToDateJSBundleInCache() {
        if (this.mIsDevSupportEnabled && this.mJSBundleTempFile.exists()) {
            try {
                String packageName = this.mApplicationContext.getPackageName();
                PackageInfo thisPackage = this.mApplicationContext.getPackageManager().getPackageInfo(packageName, 0);
                if (this.mJSBundleTempFile.lastModified() > thisPackage.lastUpdateTime) {
                    File exopackageDir = new File(String.format(Locale.US, EXOPACKAGE_LOCATION_FORMAT, packageName));
                    if (exopackageDir.exists()) {
                        return this.mJSBundleTempFile.lastModified() > exopackageDir.lastModified();
                    }
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                FLog.e((String)"ReactNative", (String)"DevSupport is unable to get current app info");
            }
        }
        return false;
    }

    public boolean hasBundleInAssets(String bundleAssetName) {
        try {
            String[] assets = this.mApplicationContext.getAssets().list("");
            for (int i = 0; i < assets.length; ++i) {
                if (!assets[i].equals(bundleAssetName)) continue;
                return true;
            }
        }
        catch (IOException e) {
            FLog.e((String)"ReactNative", (String)"Error while loading assets list");
        }
        return false;
    }

    private void resetCurrentContext(@Nullable ReactContext reactContext) {
        if (this.mCurrentContext == reactContext) {
            return;
        }
        this.mCurrentContext = reactContext;
        if (this.mDebugOverlayController != null) {
            this.mDebugOverlayController.setFpsDebugViewVisible(false);
        }
        if (reactContext != null) {
            this.mDebugOverlayController = new DebugOverlayController(reactContext);
        }
        if (this.mCurrentContext != null) {
            try {
                URL sourceUrl = new URL(this.getSourceUrl());
                String path = sourceUrl.getPath().substring(1);
                String host = sourceUrl.getHost();
                int port = sourceUrl.getPort();
                this.mCurrentContext.getJSModule(HMRClient.class).setup("android", path, host, port, this.mDevSettings.isHotModuleReplacementEnabled());
            }
            catch (MalformedURLException e) {
                this.showNewJavaError(e.getMessage(), e);
            }
        }
        this.reloadSettings();
    }

    @Override
    public void reloadSettings() {
        if (UiThreadUtil.isOnUiThread()) {
            this.reload();
        } else {
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    DevSupportManagerImpl.this.reload();
                }
            });
        }
    }

    @Override
    public void onInternalSettingsChanged() {
        this.reloadSettings();
    }

    @Override
    public void handleReloadJS() {
        UiThreadUtil.assertOnUiThread();
        ReactMarker.logMarker(ReactMarkerConstants.RELOAD, this.mDevSettings.getPackagerConnectionSettings().getDebugServerHost());
        this.hideRedboxDialog();
        if (this.mDevSettings.isRemoteJSDebugEnabled()) {
            PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.RN_CORE, "RNCore: load from Proxy");
            this.mDevLoadingViewController.showForRemoteJSEnabled();
            this.mDevLoadingViewVisible = true;
            this.reloadJSInProxyMode();
        } else {
            PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.RN_CORE, "RNCore: load from Server");
            String bundleURL = this.mDevServerHelper.getDevServerBundleURL((String)Assertions.assertNotNull((Object)this.mJSAppBundleName));
            this.reloadJSFromServer(bundleURL);
        }
    }

    @Override
    public void isPackagerRunning(PackagerStatusCallback callback) {
        this.mDevServerHelper.isPackagerRunning(callback);
    }

    @Override
    @Nullable
    public File downloadBundleResourceFromUrlSync(String resourceURL, File outputFile) {
        return this.mDevServerHelper.downloadBundleResourceFromUrlSync(resourceURL, outputFile);
    }

    @Override
    @Nullable
    public String getLastErrorTitle() {
        return this.mLastErrorTitle;
    }

    @Override
    @Nullable
    public StackFrame[] getLastErrorStack() {
        return this.mLastErrorStack;
    }

    @Override
    public void onPackagerConnected() {
    }

    @Override
    public void onPackagerDisconnected() {
    }

    @Override
    public void onPackagerReloadCommand() {
        this.mDevServerHelper.disableDebugger();
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DevSupportManagerImpl.this.handleReloadJS();
            }
        });
    }

    @Override
    public void onPackagerDevMenuCommand() {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DevSupportManagerImpl.this.showDevOptionsDialog();
            }
        });
    }

    @Override
    public void onCaptureHeapCommand(final Responder responder) {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DevSupportManagerImpl.this.handleCaptureHeap(responder);
            }
        });
    }

    @Override
    @Nullable
    public Map<String, RequestHandler> customCommandHandlers() {
        return this.mCustomPackagerCommandHandlers;
    }

    private void handleCaptureHeap(final Responder responder) {
        if (this.mCurrentContext == null) {
            return;
        }
        JSCHeapCapture heapCapture = this.mCurrentContext.getNativeModule(JSCHeapCapture.class);
        heapCapture.captureHeap(this.mApplicationContext.getCacheDir().getPath(), new JSCHeapCapture.CaptureCallback(){

            @Override
            public void onSuccess(File capture) {
                responder.respond(capture.toString());
            }

            @Override
            public void onFailure(JSCHeapCapture.CaptureException error) {
                responder.error(error.toString());
            }
        });
    }

    private void updateLastErrorInfo(@Nullable String message, StackFrame[] stack, int errorCookie, ErrorType errorType) {
        this.mLastErrorTitle = message;
        this.mLastErrorStack = stack;
        this.mLastErrorCookie = errorCookie;
        this.mLastErrorType = errorType;
    }

    private void reloadJSInProxyMode() {
        this.mDevServerHelper.launchJSDevtools();
        JavaJSExecutor.Factory factory = new JavaJSExecutor.Factory(){

            @Override
            public JavaJSExecutor create() throws Exception {
                WebsocketJavaScriptExecutor executor = new WebsocketJavaScriptExecutor();
                SimpleSettableFuture future = new SimpleSettableFuture();
                executor.connect(DevSupportManagerImpl.this.mDevServerHelper.getWebsocketProxyURL(), DevSupportManagerImpl.this.getExecutorConnectCallback(future));
                try {
                    future.get(90L, TimeUnit.SECONDS);
                    return executor;
                }
                catch (ExecutionException e) {
                    throw (Exception)e.getCause();
                }
                catch (InterruptedException | TimeoutException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.mReactInstanceManagerHelper.onReloadWithJSDebugger(factory);
    }

    private WebsocketJavaScriptExecutor.JSExecutorConnectCallback getExecutorConnectCallback(final SimpleSettableFuture<Boolean> future) {
        return new WebsocketJavaScriptExecutor.JSExecutorConnectCallback(){

            @Override
            public void onSuccess() {
                future.set(true);
                DevSupportManagerImpl.this.mDevLoadingViewController.hide();
                DevSupportManagerImpl.this.mDevLoadingViewVisible = false;
            }

            @Override
            public void onFailure(Throwable cause) {
                DevSupportManagerImpl.this.mDevLoadingViewController.hide();
                DevSupportManagerImpl.this.mDevLoadingViewVisible = false;
                FLog.e((String)"ReactNative", (String)"Failed to connect to debugger!", (Throwable)cause);
                future.setException(new IOException(DevSupportManagerImpl.this.mApplicationContext.getString(R.string.catalyst_debug_error), cause));
            }
        };
    }

    @Override
    public void reloadJSFromServer(String bundleURL) {
        ReactMarker.logMarker(ReactMarkerConstants.DOWNLOAD_START);
        this.mDevLoadingViewController.showForUrl(bundleURL);
        this.mDevLoadingViewVisible = true;
        final BundleDownloader.BundleInfo bundleInfo = new BundleDownloader.BundleInfo();
        this.mDevServerHelper.downloadBundleFromURL(new DevBundleDownloadListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess() {
                DevSupportManagerImpl.this.mDevLoadingViewController.hide();
                DevSupportManagerImpl.this.mDevLoadingViewVisible = false;
                DevSupportManagerImpl devSupportManagerImpl = DevSupportManagerImpl.this;
                synchronized (devSupportManagerImpl) {
                    ((DevSupportManagerImpl)DevSupportManagerImpl.this).mBundleStatus.isLastDownloadSucess = true;
                    ((DevSupportManagerImpl)DevSupportManagerImpl.this).mBundleStatus.updateTimestamp = System.currentTimeMillis();
                }
                if (DevSupportManagerImpl.this.mBundleDownloadListener != null) {
                    DevSupportManagerImpl.this.mBundleDownloadListener.onSuccess();
                }
                UiThreadUtil.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ReactMarker.logMarker(ReactMarkerConstants.DOWNLOAD_END, bundleInfo.toJSONString());
                        DevSupportManagerImpl.this.mReactInstanceManagerHelper.onJSBundleLoadedFromServer();
                    }
                });
            }

            @Override
            public void onProgress(@Nullable String status, @Nullable Integer done, @Nullable Integer total) {
                DevSupportManagerImpl.this.mDevLoadingViewController.updateProgress(status, done, total);
                if (DevSupportManagerImpl.this.mBundleDownloadListener != null) {
                    DevSupportManagerImpl.this.mBundleDownloadListener.onProgress(status, done, total);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(final Exception cause) {
                DevSupportManagerImpl.this.mDevLoadingViewController.hide();
                DevSupportManagerImpl.this.mDevLoadingViewVisible = false;
                DevSupportManagerImpl devSupportManagerImpl = DevSupportManagerImpl.this;
                synchronized (devSupportManagerImpl) {
                    ((DevSupportManagerImpl)DevSupportManagerImpl.this).mBundleStatus.isLastDownloadSucess = false;
                }
                if (DevSupportManagerImpl.this.mBundleDownloadListener != null) {
                    DevSupportManagerImpl.this.mBundleDownloadListener.onFailure(cause);
                }
                FLog.e((String)"ReactNative", (String)"Unable to download JS bundle", (Throwable)cause);
                UiThreadUtil.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (cause instanceof DebugServerException) {
                            DebugServerException debugServerException = (DebugServerException)cause;
                            DevSupportManagerImpl.this.showNewJavaError(debugServerException.getMessage(), cause);
                        } else {
                            DevSupportManagerImpl.this.showNewJavaError(DevSupportManagerImpl.this.mApplicationContext.getString(R.string.catalyst_reload_error), cause);
                        }
                    }
                });
            }
        }, this.mJSBundleTempFile, bundleURL, bundleInfo);
    }

    @Override
    public void startInspector() {
        if (this.mIsDevSupportEnabled) {
            this.mDevServerHelper.openInspectorConnection();
        }
    }

    @Override
    public void stopInspector() {
        this.mDevServerHelper.closeInspectorConnection();
    }

    @Override
    public void setHotModuleReplacementEnabled(final boolean isHotModuleReplacementEnabled) {
        if (!this.mIsDevSupportEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DevSupportManagerImpl.this.mDevSettings.setHotModuleReplacementEnabled(isHotModuleReplacementEnabled);
                DevSupportManagerImpl.this.handleReloadJS();
            }
        });
    }

    @Override
    public void setRemoteJSDebugEnabled(final boolean isRemoteJSDebugEnabled) {
        if (!this.mIsDevSupportEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DevSupportManagerImpl.this.mDevSettings.setRemoteJSDebugEnabled(isRemoteJSDebugEnabled);
                DevSupportManagerImpl.this.handleReloadJS();
            }
        });
    }

    @Override
    public void setFpsDebugEnabled(final boolean isFpsDebugEnabled) {
        if (!this.mIsDevSupportEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DevSupportManagerImpl.this.mDevSettings.setFpsDebugEnabled(isFpsDebugEnabled);
            }
        });
    }

    @Override
    public void toggleElementInspector() {
        if (!this.mIsDevSupportEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DevSupportManagerImpl.this.mDevSettings.setElementInspectorEnabled(!DevSupportManagerImpl.this.mDevSettings.isElementInspectorEnabled());
                DevSupportManagerImpl.this.mReactInstanceManagerHelper.toggleElementInspector();
            }
        });
    }

    private void reload() {
        UiThreadUtil.assertOnUiThread();
        if (this.mIsDevSupportEnabled) {
            if (this.mDebugOverlayController != null) {
                this.mDebugOverlayController.setFpsDebugViewVisible(this.mDevSettings.isFpsDebugEnabled());
            }
            if (!this.mIsShakeDetectorStarted) {
                this.mShakeDetector.start((SensorManager)this.mApplicationContext.getSystemService("sensor"));
                this.mIsShakeDetectorStarted = true;
            }
            if (!this.mIsReceiverRegistered) {
                IntentFilter filter = new IntentFilter();
                filter.addAction(DevSupportManagerImpl.getReloadAppAction(this.mApplicationContext));
                this.mApplicationContext.registerReceiver(this.mReloadAppBroadcastReceiver, filter);
                this.mIsReceiverRegistered = true;
            }
            if (this.mDevLoadingViewVisible) {
                this.mDevLoadingViewController.showMessage("Reloading...");
            }
            this.mDevServerHelper.openPackagerConnection(this.getClass().getSimpleName(), this);
        } else {
            if (this.mDebugOverlayController != null) {
                this.mDebugOverlayController.setFpsDebugViewVisible(false);
            }
            if (this.mIsShakeDetectorStarted) {
                this.mShakeDetector.stop();
                this.mIsShakeDetectorStarted = false;
            }
            if (this.mIsReceiverRegistered) {
                this.mApplicationContext.unregisterReceiver(this.mReloadAppBroadcastReceiver);
                this.mIsReceiverRegistered = false;
            }
            this.hideRedboxDialog();
            this.hideDevOptionsDialog();
            this.mDevLoadingViewController.hide();
            this.mDevServerHelper.closePackagerConnection();
        }
    }

    private static String getReloadAppAction(Context context) {
        return context.getPackageName() + RELOAD_APP_ACTION_SUFFIX;
    }

    private class JSExceptionLogger
    implements ExceptionLogger {
        private JSExceptionLogger() {
        }

        @Override
        public void log(Exception e) {
            StringBuilder message = new StringBuilder(e.getMessage() == null ? "Exception in native call from JS" : e.getMessage());
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                message.append("\n\n").append(cause.getMessage());
            }
            if (e instanceof JSException) {
                FLog.e((String)"ReactNative", (String)"Exception in native call from JS", (Throwable)e);
                String stack = ((JSException)e).getStack();
                message.append("\n\n").append(stack);
                DevSupportManagerImpl.this.showNewError(message.toString(), new StackFrame[0], -1, ErrorType.JS);
            } else {
                DevSupportManagerImpl.this.showNewJavaError(message.toString(), e);
            }
        }
    }

    private static interface ExceptionLogger {
        public void log(Exception var1);
    }

    private static enum ErrorType {
        JS,
        NATIVE;

    }
}

