/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.os.Build;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.views.text.ReactTypefaceUtils;
import com.facebook.react.views.text.TextTransform;
import com.facebook.yoga.YogaDirection;

public class TextAttributeProps {
    private static final String INLINE_IMAGE_PLACEHOLDER = "I";
    public static final int UNSET = -1;
    private static final String PROP_SHADOW_OFFSET = "textShadowOffset";
    private static final String PROP_SHADOW_OFFSET_WIDTH = "width";
    private static final String PROP_SHADOW_OFFSET_HEIGHT = "height";
    private static final String PROP_SHADOW_RADIUS = "textShadowRadius";
    private static final String PROP_SHADOW_COLOR = "textShadowColor";
    private static final String PROP_TEXT_TRANSFORM = "textTransform";
    private static final int DEFAULT_TEXT_SHADOW_COLOR = 0x55000000;
    protected float mLineHeight = Float.NaN;
    protected boolean mIsColorSet = false;
    protected boolean mAllowFontScaling = true;
    protected int mColor;
    protected boolean mIsBackgroundColorSet = false;
    protected int mBackgroundColor;
    protected int mNumberOfLines = -1;
    protected int mFontSize = -1;
    protected float mFontSizeInput = -1.0f;
    protected float mLineHeightInput = -1.0f;
    protected float mLetterSpacingInput = Float.NaN;
    protected int mTextAlign = 0;
    protected int mTextBreakStrategy = Build.VERSION.SDK_INT < 23 ? 0 : 1;
    protected int mJustificationMode = Build.VERSION.SDK_INT < 26 ? 0 : 0;
    protected TextTransform mTextTransform = TextTransform.UNSET;
    protected float mTextShadowOffsetDx = 0.0f;
    protected float mTextShadowOffsetDy = 0.0f;
    protected float mTextShadowRadius = 1.0f;
    protected int mTextShadowColor = 0x55000000;
    protected boolean mIsUnderlineTextDecorationSet = false;
    protected boolean mIsLineThroughTextDecorationSet = false;
    protected boolean mIncludeFontPadding = true;
    protected int mFontStyle = -1;
    protected int mFontWeight = -1;
    @Nullable
    protected String mFontFamily = null;
    @Nullable
    protected String mFontFeatureSettings = null;
    protected boolean mContainsImages = false;
    protected float mHeightOfTallestInlineImage = Float.NaN;
    private final ReactStylesDiffMap mProps;

    public TextAttributeProps(ReactStylesDiffMap props) {
        this.mProps = props;
        this.setNumberOfLines(this.getIntProp("numberOfLines", -1));
        this.setLineHeight(this.getFloatProp("lineHeight", -1.0f));
        this.setLetterSpacing(this.getFloatProp("letterSpacing", Float.NaN));
        this.setAllowFontScaling(this.getBooleanProp("allowFontScaling", true));
        this.setTextAlign(this.getStringProp("textAlign"));
        this.setFontSize(this.getFloatProp("fontSize", -1.0f));
        this.setColor(props.hasKey("color") ? Integer.valueOf(props.getInt("color", 0)) : null);
        this.setColor(props.hasKey("foregroundColor") ? Integer.valueOf(props.getInt("foregroundColor", 0)) : null);
        this.setBackgroundColor(props.hasKey("backgroundColor") ? Integer.valueOf(props.getInt("backgroundColor", 0)) : null);
        this.setFontFamily(this.getStringProp("fontFamily"));
        this.setFontWeight(this.getStringProp("fontWeight"));
        this.setFontStyle(this.getStringProp("fontStyle"));
        this.setFontVariant(this.getArrayProp("fontVariant"));
        this.setIncludeFontPadding(this.getBooleanProp("includeFontPadding", true));
        this.setTextDecorationLine(this.getStringProp("textDecorationLine"));
        this.setTextBreakStrategy(this.getStringProp("textBreakStrategy"));
        this.setTextShadowOffset(props.hasKey(PROP_SHADOW_OFFSET) ? props.getMap(PROP_SHADOW_OFFSET) : null);
        this.setTextShadowRadius(this.getIntProp(PROP_SHADOW_RADIUS, 1));
        this.setTextShadowColor(this.getIntProp(PROP_SHADOW_COLOR, 0x55000000));
        this.setTextTransform(this.getStringProp(PROP_TEXT_TRANSFORM));
    }

    private boolean getBooleanProp(String name, boolean defaultValue) {
        if (this.mProps.hasKey(name)) {
            return this.mProps.getBoolean(name, defaultValue);
        }
        return defaultValue;
    }

    private String getStringProp(String name) {
        if (this.mProps.hasKey(name)) {
            return this.mProps.getString(name);
        }
        return null;
    }

    private int getIntProp(String name, int defaultvalue) {
        if (this.mProps.hasKey(name)) {
            return this.mProps.getInt(name, defaultvalue);
        }
        return defaultvalue;
    }

    private float getFloatProp(String name, float defaultvalue) {
        if (this.mProps.hasKey(name)) {
            return this.mProps.getFloat(name, defaultvalue);
        }
        return defaultvalue;
    }

    @Nullable
    private ReadableArray getArrayProp(String name) {
        if (this.mProps.hasKey(name)) {
            return this.mProps.getArray(name);
        }
        return null;
    }

    public float getEffectiveLineHeight() {
        boolean useInlineViewHeight = !Float.isNaN(this.mLineHeight) && !Float.isNaN(this.mHeightOfTallestInlineImage) && this.mHeightOfTallestInlineImage > this.mLineHeight;
        return useInlineViewHeight ? this.mHeightOfTallestInlineImage : this.mLineHeight;
    }

    public int getTextAlign() {
        int textAlign = this.mTextAlign;
        if (this.getLayoutDirection() == YogaDirection.RTL) {
            if (textAlign == 5) {
                textAlign = 3;
            } else if (textAlign == 3) {
                textAlign = 5;
            }
        }
        return textAlign;
    }

    public void setNumberOfLines(int numberOfLines) {
        this.mNumberOfLines = numberOfLines == 0 ? -1 : numberOfLines;
    }

    public void setLineHeight(float lineHeight) {
        this.mLineHeightInput = lineHeight;
        this.mLineHeight = lineHeight == -1.0f ? Float.NaN : (this.mAllowFontScaling ? PixelUtil.toPixelFromSP(lineHeight) : PixelUtil.toPixelFromDIP(lineHeight));
    }

    public void setLetterSpacing(float letterSpacing) {
        this.mLetterSpacingInput = letterSpacing;
    }

    public float getLetterSpacing() {
        float letterSpacingPixels;
        float f = letterSpacingPixels = this.mAllowFontScaling ? PixelUtil.toPixelFromSP(this.mLetterSpacingInput) : PixelUtil.toPixelFromDIP(this.mLetterSpacingInput);
        if (this.mFontSize <= 0) {
            throw new IllegalArgumentException("FontSize should be a positive value. Current value: " + this.mFontSize);
        }
        return letterSpacingPixels / (float)this.mFontSize;
    }

    public void setAllowFontScaling(boolean allowFontScaling) {
        if (allowFontScaling != this.mAllowFontScaling) {
            this.mAllowFontScaling = allowFontScaling;
            this.setFontSize(this.mFontSizeInput);
            this.setLineHeight(this.mLineHeightInput);
            this.setLetterSpacing(this.mLetterSpacingInput);
        }
    }

    public void setTextAlign(@Nullable String textAlign) {
        if ("justify".equals(textAlign)) {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mJustificationMode = 1;
            }
            this.mTextAlign = 3;
        } else {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mJustificationMode = 0;
            }
            if (textAlign == null || "auto".equals(textAlign)) {
                this.mTextAlign = 0;
            } else if ("left".equals(textAlign)) {
                this.mTextAlign = 3;
            } else if ("right".equals(textAlign)) {
                this.mTextAlign = 5;
            } else if ("center".equals(textAlign)) {
                this.mTextAlign = 1;
            } else {
                throw new JSApplicationIllegalArgumentException("Invalid textAlign: " + textAlign);
            }
        }
    }

    public void setFontSize(float fontSize) {
        this.mFontSizeInput = fontSize;
        if (fontSize != -1.0f) {
            fontSize = this.mAllowFontScaling ? (float)Math.ceil(PixelUtil.toPixelFromSP(fontSize)) : (float)Math.ceil(PixelUtil.toPixelFromDIP(fontSize));
        }
        this.mFontSize = (int)fontSize;
    }

    public void setColor(@Nullable Integer color) {
        boolean bl = this.mIsColorSet = color != null;
        if (this.mIsColorSet) {
            this.mColor = color;
        }
    }

    public void setBackgroundColor(Integer color) {
        boolean bl = this.mIsBackgroundColorSet = color != null;
        if (this.mIsBackgroundColorSet) {
            this.mBackgroundColor = color;
        }
    }

    public void setFontFamily(@Nullable String fontFamily) {
        this.mFontFamily = fontFamily;
    }

    public void setFontVariant(@Nullable ReadableArray fontVariant) {
        this.mFontFeatureSettings = ReactTypefaceUtils.parseFontVariant(fontVariant);
    }

    public void setFontWeight(@Nullable String fontWeightString) {
        int fontWeightNumeric = fontWeightString != null ? TextAttributeProps.parseNumericFontWeight(fontWeightString) : -1;
        int fontWeight = -1;
        if (fontWeightNumeric >= 500 || "bold".equals(fontWeightString)) {
            fontWeight = 1;
        } else if ("normal".equals(fontWeightString) || fontWeightNumeric != -1 && fontWeightNumeric < 500) {
            fontWeight = 0;
        }
        if (fontWeight != this.mFontWeight) {
            this.mFontWeight = fontWeight;
        }
    }

    public void setFontStyle(@Nullable String fontStyleString) {
        int fontStyle = -1;
        if ("italic".equals(fontStyleString)) {
            fontStyle = 2;
        } else if ("normal".equals(fontStyleString)) {
            fontStyle = 0;
        }
        if (fontStyle != this.mFontStyle) {
            this.mFontStyle = fontStyle;
        }
    }

    public void setIncludeFontPadding(boolean includepad) {
        this.mIncludeFontPadding = includepad;
    }

    public void setTextDecorationLine(@Nullable String textDecorationLineString) {
        this.mIsUnderlineTextDecorationSet = false;
        this.mIsLineThroughTextDecorationSet = false;
        if (textDecorationLineString != null) {
            for (String textDecorationLineSubString : textDecorationLineString.split("-")) {
                if ("underline".equals(textDecorationLineSubString)) {
                    this.mIsUnderlineTextDecorationSet = true;
                    continue;
                }
                if (!"strikethrough".equals(textDecorationLineSubString)) continue;
                this.mIsLineThroughTextDecorationSet = true;
            }
        }
    }

    public void setTextBreakStrategy(@Nullable String textBreakStrategy) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        if (textBreakStrategy == null || "highQuality".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 1;
        } else if ("simple".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 0;
        } else if ("balanced".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 2;
        } else {
            throw new JSApplicationIllegalArgumentException("Invalid textBreakStrategy: " + textBreakStrategy);
        }
    }

    public void setTextShadowOffset(ReadableMap offsetMap) {
        this.mTextShadowOffsetDx = 0.0f;
        this.mTextShadowOffsetDy = 0.0f;
        if (offsetMap != null) {
            if (offsetMap.hasKey(PROP_SHADOW_OFFSET_WIDTH) && !offsetMap.isNull(PROP_SHADOW_OFFSET_WIDTH)) {
                this.mTextShadowOffsetDx = PixelUtil.toPixelFromDIP(offsetMap.getDouble(PROP_SHADOW_OFFSET_WIDTH));
            }
            if (offsetMap.hasKey(PROP_SHADOW_OFFSET_HEIGHT) && !offsetMap.isNull(PROP_SHADOW_OFFSET_HEIGHT)) {
                this.mTextShadowOffsetDy = PixelUtil.toPixelFromDIP(offsetMap.getDouble(PROP_SHADOW_OFFSET_HEIGHT));
            }
        }
    }

    public void setTextShadowRadius(float textShadowRadius) {
        if (textShadowRadius != this.mTextShadowRadius) {
            this.mTextShadowRadius = textShadowRadius;
        }
    }

    public void setTextShadowColor(int textShadowColor) {
        if (textShadowColor != this.mTextShadowColor) {
            this.mTextShadowColor = textShadowColor;
        }
    }

    public void setTextTransform(@Nullable String textTransform) {
        if (textTransform == null || "none".equals(textTransform)) {
            this.mTextTransform = TextTransform.NONE;
        } else if ("uppercase".equals(textTransform)) {
            this.mTextTransform = TextTransform.UPPERCASE;
        } else if ("lowercase".equals(textTransform)) {
            this.mTextTransform = TextTransform.LOWERCASE;
        } else if ("capitalize".equals(textTransform)) {
            this.mTextTransform = TextTransform.CAPITALIZE;
        } else {
            throw new JSApplicationIllegalArgumentException("Invalid textTransform: " + textTransform);
        }
    }

    private static int parseNumericFontWeight(String fontWeightString) {
        return fontWeightString.length() == 3 && fontWeightString.endsWith("00") && fontWeightString.charAt(0) <= '9' && fontWeightString.charAt(0) >= '1' ? 100 * (fontWeightString.charAt(0) - 48) : -1;
    }

    private YogaDirection getLayoutDirection() {
        return YogaDirection.LTR;
    }

    public float getBottomPadding() {
        return this.getPaddingProp("paddingBottom");
    }

    public float getLeftPadding() {
        return this.getPaddingProp("paddingLeft");
    }

    public float getStartPadding() {
        return this.getPaddingProp("paddingStart");
    }

    public float getEndPadding() {
        return this.getPaddingProp("paddingEnd");
    }

    public float getTopPadding() {
        return this.getPaddingProp("paddingTop");
    }

    public float getRightPadding() {
        return this.getPaddingProp("paddingRight");
    }

    private float getPaddingProp(String paddingType) {
        if (this.mProps.hasKey("padding")) {
            return PixelUtil.toPixelFromDIP(this.getFloatProp("padding", 0.0f));
        }
        return PixelUtil.toPixelFromDIP(this.getFloatProp(paddingType, 0.0f));
    }
}

