/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.slider;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.view.View;
import android.widget.SeekBar;
import androidx.annotation.Nullable;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewManagerDelegate;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.viewmanagers.SliderManagerDelegate;
import com.facebook.react.viewmanagers.SliderManagerInterface;
import com.facebook.react.views.slider.ReactSlider;
import com.facebook.react.views.slider.ReactSliderEvent;
import com.facebook.react.views.slider.ReactSlidingCompleteEvent;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;
import java.util.Map;

public class ReactSliderManager
extends SimpleViewManager<ReactSlider>
implements SliderManagerInterface<ReactSlider> {
    private static final int STYLE = 16842875;
    public static final String REACT_CLASS = "RCTSlider";
    private static final SeekBar.OnSeekBarChangeListener ON_CHANGE_LISTENER = new SeekBar.OnSeekBarChangeListener(){

        public void onProgressChanged(SeekBar seekbar, int progress, boolean fromUser) {
            ReactContext reactContext = (ReactContext)seekbar.getContext();
            reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher().dispatchEvent(new ReactSliderEvent(seekbar.getId(), ((ReactSlider)seekbar).toRealProgress(progress), fromUser));
        }

        public void onStartTrackingTouch(SeekBar seekbar) {
        }

        public void onStopTrackingTouch(SeekBar seekbar) {
            ReactContext reactContext = (ReactContext)seekbar.getContext();
            reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher().dispatchEvent(new ReactSlidingCompleteEvent(seekbar.getId(), ((ReactSlider)seekbar).toRealProgress(seekbar.getProgress())));
        }
    };
    private final ViewManagerDelegate<ReactSlider> mDelegate = new SliderManagerDelegate<ReactSlider, ReactSliderManager>(this);
    protected static ReactSliderAccessibilityDelegate sAccessibilityDelegate = new ReactSliderAccessibilityDelegate();

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public LayoutShadowNode createShadowNodeInstance() {
        return new ReactSliderShadowNode();
    }

    @Override
    public Class getShadowNodeClass() {
        return ReactSliderShadowNode.class;
    }

    @Override
    protected ReactSlider createViewInstance(ThemedReactContext context) {
        ReactSlider slider = new ReactSlider((Context)context, null, 16842875);
        ViewCompat.setAccessibilityDelegate((View)slider, (AccessibilityDelegateCompat)sAccessibilityDelegate);
        return slider;
    }

    @Override
    @ReactProp(name="enabled", defaultBoolean=true)
    public void setEnabled(ReactSlider view, boolean enabled) {
        view.setEnabled(enabled);
    }

    @Override
    @ReactProp(name="value", defaultDouble=0.0)
    public void setValue(ReactSlider view, double value) {
        view.setOnSeekBarChangeListener(null);
        view.setValue(value);
        view.setOnSeekBarChangeListener(ON_CHANGE_LISTENER);
    }

    @Override
    @ReactProp(name="minimumValue", defaultDouble=0.0)
    public void setMinimumValue(ReactSlider view, double value) {
        view.setMinValue(value);
    }

    @Override
    @ReactProp(name="maximumValue", defaultDouble=1.0)
    public void setMaximumValue(ReactSlider view, double value) {
        view.setMaxValue(value);
    }

    @Override
    @ReactProp(name="step", defaultDouble=0.0)
    public void setStep(ReactSlider view, double value) {
        view.setStep(value);
    }

    @Override
    @ReactProp(name="thumbTintColor", customType="Color")
    public void setThumbTintColor(ReactSlider view, Integer color) {
        if (color == null) {
            view.getThumb().clearColorFilter();
        } else {
            view.getThumb().setColorFilter(color.intValue(), PorterDuff.Mode.SRC_IN);
        }
    }

    @Override
    @ReactProp(name="minimumTrackTintColor", customType="Color")
    public void setMinimumTrackTintColor(ReactSlider view, Integer color) {
        LayerDrawable drawable = (LayerDrawable)view.getProgressDrawable().getCurrent();
        Drawable progress = drawable.findDrawableByLayerId(16908301);
        if (color == null) {
            progress.clearColorFilter();
        } else {
            progress.setColorFilter(color.intValue(), PorterDuff.Mode.SRC_IN);
        }
    }

    @Override
    @ReactProp(name="maximumTrackTintColor", customType="Color")
    public void setMaximumTrackTintColor(ReactSlider view, Integer color) {
        LayerDrawable drawable = (LayerDrawable)view.getProgressDrawable().getCurrent();
        Drawable background = drawable.findDrawableByLayerId(0x1020000);
        if (color == null) {
            background.clearColorFilter();
        } else {
            background.setColorFilter(color.intValue(), PorterDuff.Mode.SRC_IN);
        }
    }

    @Override
    public void setDisabled(ReactSlider view, boolean value) {
    }

    @Override
    public void setMaximumTrackImage(ReactSlider view, @Nullable ReadableMap value) {
    }

    @Override
    public void setMinimumTrackImage(ReactSlider view, @Nullable ReadableMap value) {
    }

    @Override
    public void setTestID(ReactSlider view, @Nullable String value) {
        super.setTestId(view, value);
    }

    @Override
    public void setThumbImage(ReactSlider view, @Nullable ReadableMap value) {
    }

    @Override
    public void setTrackImage(ReactSlider view, @Nullable ReadableMap value) {
    }

    @Override
    protected void addEventEmitters(ThemedReactContext reactContext, ReactSlider view) {
        view.setOnSeekBarChangeListener(ON_CHANGE_LISTENER);
    }

    @Override
    public Map getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.of("topSlidingComplete", MapBuilder.of("registrationName", "onSlidingComplete"));
    }

    @Override
    public long measure(Context context, ReadableMap localData, ReadableMap props, ReadableMap state, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
        ReactSlider reactSlider = new ReactSlider(context, null, 16842875);
        int spec = View.MeasureSpec.makeMeasureSpec((int)-2, (int)0);
        reactSlider.measure(spec, spec);
        return YogaMeasureOutput.make(PixelUtil.toDIPFromPixel(reactSlider.getMeasuredWidth()), PixelUtil.toDIPFromPixel(reactSlider.getMeasuredHeight()));
    }

    @Override
    protected ViewManagerDelegate<ReactSlider> getDelegate() {
        return this.mDelegate;
    }

    protected static class ReactSliderAccessibilityDelegate
    extends AccessibilityDelegateCompat {
        protected ReactSliderAccessibilityDelegate() {
        }

        private static boolean isSliderAction(int action) {
            return action == AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_FORWARD.getId() || action == AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_BACKWARD.getId() || action == AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SET_PROGRESS.getId();
        }

        public boolean performAccessibilityAction(View host, int action, Bundle args) {
            if (ReactSliderAccessibilityDelegate.isSliderAction(action)) {
                ON_CHANGE_LISTENER.onStartTrackingTouch((SeekBar)host);
            }
            boolean rv = super.performAccessibilityAction(host, action, args);
            if (ReactSliderAccessibilityDelegate.isSliderAction(action)) {
                ON_CHANGE_LISTENER.onStopTrackingTouch((SeekBar)host);
            }
            return rv;
        }
    }

    static class ReactSliderShadowNode
    extends LayoutShadowNode
    implements YogaMeasureFunction {
        private int mWidth;
        private int mHeight;
        private boolean mMeasured;

        private ReactSliderShadowNode() {
            this.initMeasureFunction();
        }

        private void initMeasureFunction() {
            this.setMeasureFunction(this);
        }

        @Override
        public long measure(YogaNode node, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
            if (!this.mMeasured) {
                ReactSlider reactSlider = new ReactSlider((Context)this.getThemedContext(), null, 16842875);
                int spec = View.MeasureSpec.makeMeasureSpec((int)-2, (int)0);
                reactSlider.measure(spec, spec);
                this.mWidth = reactSlider.getMeasuredWidth();
                this.mHeight = reactSlider.getMeasuredHeight();
                this.mMeasured = true;
            }
            return YogaMeasureOutput.make(this.mWidth, this.mHeight);
        }
    }
}

