/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.picker;

import android.content.Context;
import android.content.res.ColorStateList;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.views.picker.ReactPickerItem;
import java.util.List;

class ReactPickerAdapter
extends ArrayAdapter<ReactPickerItem> {
    private final LayoutInflater mInflater;
    @Nullable
    private Integer mPrimaryTextColor;

    public ReactPickerAdapter(Context context, List<ReactPickerItem> data) {
        super(context, 0, data);
        this.mInflater = (LayoutInflater)Assertions.assertNotNull((Object)context.getSystemService("layout_inflater"));
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.getView(position, convertView, parent, false);
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return this.getView(position, convertView, parent, true);
    }

    private View getView(int position, View convertView, ViewGroup parent, boolean isDropdown) {
        ReactPickerItem item = (ReactPickerItem)this.getItem(position);
        boolean isNew = false;
        if (convertView == null) {
            int layoutResId = isDropdown ? 0x1090009 : 17367048;
            convertView = this.mInflater.inflate(layoutResId, parent, false);
            convertView.setTag((Object)((TextView)convertView).getTextColors());
            isNew = true;
        }
        TextView textView = (TextView)convertView;
        textView.setText((CharSequence)item.label);
        if (!isDropdown && this.mPrimaryTextColor != null) {
            textView.setTextColor(this.mPrimaryTextColor.intValue());
        } else if (item.color != null) {
            textView.setTextColor(item.color.intValue());
        } else if (textView.getTag() != null && !isNew) {
            textView.setTextColor((ColorStateList)textView.getTag());
        }
        return textView;
    }

    @Nullable
    public Integer getPrimaryTextColor() {
        return this.mPrimaryTextColor;
    }

    public void setPrimaryTextColor(@Nullable Integer primaryTextColor) {
        this.mPrimaryTextColor = primaryTextColor;
        this.notifyDataSetChanged();
    }
}

