/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.picker;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.SpinnerAdapter;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatSpinner;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.views.picker.ReactPickerAdapter;
import com.facebook.react.views.picker.ReactPickerItem;
import java.util.List;

public class ReactPicker
extends AppCompatSpinner {
    private int mMode = 0;
    @Nullable
    private OnSelectListener mOnSelectListener;
    @Nullable
    private List<ReactPickerItem> mItems;
    @Nullable
    private List<ReactPickerItem> mStagedItems;
    @Nullable
    private Integer mStagedSelection;
    @Nullable
    private Integer mStagedPrimaryTextColor;
    private final AdapterView.OnItemSelectedListener mItemSelectedListener = new AdapterView.OnItemSelectedListener(){

        public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
            if (ReactPicker.this.mOnSelectListener != null) {
                ReactPicker.this.mOnSelectListener.onItemSelected(position);
            }
        }

        public void onNothingSelected(AdapterView<?> parent) {
            if (ReactPicker.this.mOnSelectListener != null) {
                ReactPicker.this.mOnSelectListener.onItemSelected(-1);
            }
        }
    };
    private final Runnable measureAndLayout = new Runnable(){

        @Override
        public void run() {
            ReactPicker.this.measure(View.MeasureSpec.makeMeasureSpec((int)ReactPicker.this.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)ReactPicker.this.getHeight(), (int)0x40000000));
            ReactPicker.this.layout(ReactPicker.this.getLeft(), ReactPicker.this.getTop(), ReactPicker.this.getRight(), ReactPicker.this.getBottom());
        }
    };

    public ReactPicker(Context context) {
        super(context);
    }

    public ReactPicker(Context context, int mode) {
        super(context, mode);
        this.mMode = mode;
    }

    public ReactPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ReactPicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public ReactPicker(Context context, AttributeSet attrs, int defStyle, int mode) {
        super(context, attrs, defStyle, mode);
        this.mMode = mode;
    }

    public void requestLayout() {
        super.requestLayout();
        this.post(this.measureAndLayout);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.getOnItemSelectedListener() == null) {
            this.setOnItemSelectedListener(this.mItemSelectedListener);
        }
    }

    public void setOnSelectListener(@Nullable OnSelectListener onSelectListener) {
        this.mOnSelectListener = onSelectListener;
    }

    @Nullable
    public OnSelectListener getOnSelectListener() {
        return this.mOnSelectListener;
    }

    void setStagedItems(@Nullable List<ReactPickerItem> items) {
        this.mStagedItems = items;
    }

    void setStagedSelection(int selection) {
        this.mStagedSelection = selection;
    }

    void setImmediateSelection(int selection) {
        if (selection != this.getSelectedItemPosition()) {
            this.setOnItemSelectedListener(null);
            this.setSelection(selection, false);
            this.setOnItemSelectedListener(this.mItemSelectedListener);
        }
    }

    void setStagedPrimaryTextColor(@Nullable Integer primaryColor) {
        this.mStagedPrimaryTextColor = primaryColor;
    }

    void commitStagedData() {
        this.setOnItemSelectedListener(null);
        ReactPickerAdapter adapter = (ReactPickerAdapter)this.getAdapter();
        int origSelection = this.getSelectedItemPosition();
        if (this.mStagedItems != null && this.mStagedItems != this.mItems) {
            this.mItems = this.mStagedItems;
            this.mStagedItems = null;
            if (adapter == null) {
                adapter = new ReactPickerAdapter(this.getContext(), this.mItems);
                this.setAdapter((SpinnerAdapter)adapter);
            } else {
                adapter.clear();
                adapter.addAll(this.mItems);
                adapter.notifyDataSetChanged();
            }
        }
        if (this.mStagedSelection != null && this.mStagedSelection != origSelection) {
            this.setSelection(this.mStagedSelection, false);
            this.mStagedSelection = null;
        }
        if (this.mStagedPrimaryTextColor != null && adapter != null && this.mStagedPrimaryTextColor != adapter.getPrimaryTextColor()) {
            adapter.setPrimaryTextColor(this.mStagedPrimaryTextColor);
            this.mStagedPrimaryTextColor = null;
        }
        this.setOnItemSelectedListener(this.mItemSelectedListener);
    }

    @VisibleForTesting
    public int getMode() {
        return this.mMode;
    }

    public static interface OnSelectListener {
        public void onItemSelected(int var1);
    }
}

