/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.art;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.art.ARTSurfaceView;
import com.facebook.react.views.art.ARTVirtualNode;

public class ARTSurfaceViewShadowNode
extends LayoutShadowNode
implements TextureView.SurfaceTextureListener,
LifecycleEventListener {
    @Nullable
    private Surface mSurface;
    @Nullable
    private Integer mBackgroundColor;

    @ReactProp(name="backgroundColor", customType="Color")
    public void setBackgroundColor(Integer color) {
        this.mBackgroundColor = color;
        this.markUpdated();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isVirtualAnchor() {
        return true;
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiUpdater) {
        super.onCollectExtraUpdates(uiUpdater);
        this.drawOutput(false);
        uiUpdater.enqueueUpdateExtraData(this.getReactTag(), this);
    }

    private void drawOutput(boolean markAsUpdated) {
        if (this.mSurface == null || !this.mSurface.isValid()) {
            this.markChildrenUpdatesSeen(this);
            return;
        }
        try {
            Canvas canvas = this.mSurface.lockCanvas(null);
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            if (this.mBackgroundColor != null) {
                canvas.drawColor(this.mBackgroundColor.intValue());
            }
            Paint paint = new Paint();
            for (int i = 0; i < this.getChildCount(); ++i) {
                ARTVirtualNode child = (ARTVirtualNode)this.getChildAt(i);
                child.draw(canvas, paint, 1.0f);
                if (markAsUpdated) {
                    child.markUpdated();
                    continue;
                }
                child.markUpdateSeen();
            }
            if (this.mSurface == null) {
                return;
            }
            this.mSurface.unlockCanvasAndPost(canvas);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            FLog.e((String)"ReactNative", (String)(e.getClass().getSimpleName() + " in Surface.unlockCanvasAndPost"));
        }
    }

    public void setupSurfaceTextureListener(ARTSurfaceView surfaceView) {
        SurfaceTexture surface = surfaceView.getSurfaceTexture();
        surfaceView.setSurfaceTextureListener(this);
        if (surface != null && this.mSurface == null) {
            this.mSurface = new Surface(surface);
            this.drawOutput(true);
        }
    }

    private void markChildrenUpdatesSeen(ReactShadowNode shadowNode) {
        for (int i = 0; i < shadowNode.getChildCount(); ++i) {
            Object child = shadowNode.getChildAt(i);
            child.markUpdateSeen();
            this.markChildrenUpdatesSeen((ReactShadowNode)child);
        }
    }

    @Override
    public void setThemedContext(ThemedReactContext themedContext) {
        super.setThemedContext(themedContext);
        if (Build.VERSION.SDK_INT > 24) {
            themedContext.addLifecycleEventListener(this);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (Build.VERSION.SDK_INT > 24) {
            this.getThemedContext().removeLifecycleEventListener(this);
        }
    }

    @Override
    public void onHostResume() {
        this.drawOutput(false);
    }

    @Override
    public void onHostPause() {
    }

    @Override
    public void onHostDestroy() {
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.mSurface = new Surface(surface);
        this.drawOutput(false);
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.mSurface.release();
        this.mSurface = null;
        return true;
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }
}

